/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityInvalidationListener;
import org.jetbrains.annotations.Nullable;

public class BlockEnergyCapabilityCache {
    private final ServerLevel level;
    private final BlockPos pos;
    @Nullable
    private final Direction context;
    private boolean cacheValid = false;
    @Nullable
    private IStrictEnergyHandler cachedCap = null;
    private boolean canQuery = true;
    private final ICapabilityInvalidationListener listener;

    public static BlockEnergyCapabilityCache create(ServerLevel level, BlockPos pos, @Nullable Direction context) {
        return BlockEnergyCapabilityCache.create(level, pos, context, ConstantPredicates.ALWAYS_TRUE, () -> {});
    }

    public static BlockEnergyCapabilityCache create(ServerLevel level, BlockPos pos, @Nullable Direction context, BooleanSupplier isValid, Runnable invalidationListener) {
        Objects.requireNonNull(isValid);
        Objects.requireNonNull(invalidationListener);
        pos = pos.immutable();
        BlockEnergyCapabilityCache cache = new BlockEnergyCapabilityCache(level, pos, context, isValid, invalidationListener);
        level.registerCapabilityListener(pos, cache.listener);
        return cache;
    }

    private BlockEnergyCapabilityCache(ServerLevel level, BlockPos pos, @Nullable Direction context, BooleanSupplier isValid, Runnable invalidationListener) {
        this.level = level;
        this.pos = pos;
        this.context = context;
        this.listener = () -> {
            if (!this.cacheValid) {
                return isValid.getAsBoolean();
            }
            this.canQuery = false;
            this.cacheValid = false;
            if (isValid.getAsBoolean()) {
                invalidationListener.run();
                this.canQuery = true;
                return true;
            }
            return false;
        };
    }

    public ServerLevel level() {
        return this.level;
    }

    public BlockPos pos() {
        return this.pos;
    }

    @Nullable
    public Direction context() {
        return this.context;
    }

    @Nullable
    public IStrictEnergyHandler getCapability() {
        if (!this.canQuery) {
            throw new IllegalStateException("Do not call getCapability on an invalid cache or from the invalidation listener!");
        }
        if (!this.cacheValid) {
            if (WorldUtils.isBlockLoaded((BlockGetter)this.level, this.pos)) {
                BlockState state = this.level.getBlockState(this.pos);
                BlockEntity blockEntity = state.hasBlockEntity() ? this.level.getBlockEntity(this.pos) : null;
                this.cachedCap = EnergyCompatUtils.getStrictEnergyHandler((Level)this.level, this.pos, state, blockEntity, this.context);
            } else {
                this.cachedCap = null;
            }
            this.cacheValid = true;
        }
        return this.cachedCap;
    }
}

