/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.merged.ChemicalTankWrapper;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.BlockData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.MultiTypeCapability;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookingAtUtils {
    public static final ResourceLocation ENERGY = Mekanism.rl("energy");
    public static final ResourceLocation FLUID = Mekanism.rl("fluid");
    public static final ResourceLocation GAS = Mekanism.rl("gas");
    public static final ResourceLocation INFUSE_TYPE = Mekanism.rl("infuse_type");
    public static final ResourceLocation PIGMENT = Mekanism.rl("pigment");
    public static final ResourceLocation SLURRY = Mekanism.rl("slurry");

    private LookingAtUtils() {
    }

    @Nullable
    private static MultiblockData getMultiblock(@Nullable BlockEntity tile) {
        if (tile instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)tile;
            return multiblock.getMultiblock();
        }
        if (tile instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)tile;
            for (Map.Entry<MultiblockManager<?>, Structure> entry : multiblock.getStructureMap().entrySet()) {
                Structure s;
                if (entry.getKey() == null || !(s = entry.getValue()).isValid()) continue;
                return s.getMultiblockData();
            }
        }
        return null;
    }

    public static void addInfo(LookingAtHelper info, @NotNull Entity entity) {
        if (entity instanceof EntityRobit) {
            EntityRobit robit = (EntityRobit)entity;
            LookingAtUtils.displayEnergy(info, robit);
        }
    }

    public static void addInfoOrRedirect(LookingAtHelper info, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, boolean displayTanks, boolean displayFluidTanks) {
        if (tile instanceof TileEntityBoundingBlock) {
            TileEntityBoundingBlock boundingBlock = (TileEntityBoundingBlock)tile;
            if (!boundingBlock.hasReceivedCoords() || pos.equals((Object)boundingBlock.getMainPos())) {
                return;
            }
            pos = boundingBlock.getMainPos();
            tile = WorldUtils.getTileEntity((BlockGetter)level, pos);
            if (tile == null) {
                return;
            }
            state = tile.getBlockState();
        }
        LookingAtUtils.addInfo(info, level, pos, state, tile, displayTanks, displayFluidTanks);
    }

    private static void addInfo(LookingAtHelper info, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, boolean displayTanks, boolean displayFluidTanks) {
        if (tile != null) {
            TileEntityQIORedstoneAdapter adapter;
            ItemStack itemType;
            TileEntityBin bin;
            Optional blockData = tile.getExistingData(MekanismAttachmentTypes.BLOCK_DATA);
            if (blockData.isPresent()) {
                ((BlockData)blockData.get()).addToTooltip(info::addText);
            }
            if (tile instanceof TileEntityBin && (bin = (TileEntityBin)tile).getBinSlot().isLocked()) {
                info.addText((Component)MekanismLang.LOCKED.translateColored(EnumColor.AQUA, EnumColor.GRAY, bin.getBinSlot().getLockStack()));
            }
            if (tile instanceof TileEntityQIORedstoneAdapter && !(itemType = (adapter = (TileEntityQIORedstoneAdapter)tile).getItemType()).isEmpty()) {
                info.addText(itemType.getHoverName());
                MekanismLang match = adapter.isInverted() ? MekanismLang.GENERIC_LESS_THAN : MekanismLang.GENERIC_GREATER_EQUAL;
                info.addText((Component)match.translate(MekanismLang.QIO_TRIGGER_COUNT, TextUtils.format(adapter.getCount())));
                info.addText((Component)MekanismLang.QIO_FUZZY_MODE.translate(adapter.getFuzzyMode()));
            }
        }
        MultiblockData structure = LookingAtUtils.getMultiblock(tile);
        IStrictEnergyHandler energyCapability = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapabilityIfLoaded(level, pos, state, tile, null);
        if (energyCapability != null) {
            LookingAtUtils.displayEnergy(info, energyCapability);
        } else if (structure != null && structure.isFormed()) {
            LookingAtUtils.displayEnergy(info, structure);
        }
        if (displayTanks) {
            if (displayFluidTanks && tile instanceof TileEntityUpdateable) {
                IFluidHandler fluidCapability = Capabilities.FLUID.getCapabilityIfLoaded(level, pos, state, tile, null);
                if (fluidCapability != null) {
                    TileEntityMechanicalPipe pipe;
                    FluidStack fallback = FluidStack.EMPTY;
                    if (tile instanceof TileEntityMechanicalPipe && (pipe = (TileEntityMechanicalPipe)tile).getTransmitter().hasTransmitterNetwork()) {
                        fallback = ((FluidNetwork)pipe.getTransmitter().getTransmitterNetwork()).lastFluid;
                    }
                    LookingAtUtils.displayFluid(info, fluidCapability, fallback);
                } else if (structure != null && structure.isFormed()) {
                    LookingAtUtils.displayFluid(info, structure, FluidStack.EMPTY);
                }
            }
            LookingAtUtils.addInfo(level, pos, state, tile, structure, Capabilities.GAS, multiblock -> multiblock.getGasTanks(null), info, MekanismLang.GAS, MergedChemicalTank.Current.GAS, MergedTank.CurrentType.GAS);
            LookingAtUtils.addInfo(level, pos, state, tile, structure, Capabilities.INFUSION, multiblock -> multiblock.getInfusionTanks(null), info, MekanismLang.INFUSE_TYPE, MergedChemicalTank.Current.INFUSION, MergedTank.CurrentType.INFUSION);
            LookingAtUtils.addInfo(level, pos, state, tile, structure, Capabilities.PIGMENT, multiblock -> multiblock.getPigmentTanks(null), info, MekanismLang.PIGMENT, MergedChemicalTank.Current.PIGMENT, MergedTank.CurrentType.PIGMENT);
            LookingAtUtils.addInfo(level, pos, state, tile, structure, Capabilities.SLURRY, multiblock -> multiblock.getSlurryTanks(null), info, MekanismLang.SLURRY, MergedChemicalTank.Current.SLURRY, MergedTank.CurrentType.SLURRY);
        }
    }

    private static void displayFluid(LookingAtHelper info, IFluidHandler fluidHandler, FluidStack fallback) {
        if (fluidHandler instanceof IMekanismFluidHandler) {
            IMekanismFluidHandler mekFluidHandler = (IMekanismFluidHandler)fluidHandler;
            for (IExtendedFluidTank fluidTank : mekFluidHandler.getFluidTanks(null)) {
                FluidTankWrapper wrapper;
                MergedTank mergedTank;
                MergedTank.CurrentType currentType;
                if (fluidTank instanceof FluidTankWrapper && (currentType = (mergedTank = (wrapper = (FluidTankWrapper)fluidTank).getMergedTank()).getCurrentType()) != MergedTank.CurrentType.EMPTY && currentType != MergedTank.CurrentType.FLUID) continue;
                LookingAtUtils.addFluidInfo(info, fluidTank.getFluid(), fluidTank.getCapacity(), fallback);
            }
        } else {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                LookingAtUtils.addFluidInfo(info, fluidHandler.getFluidInTank(tank), fluidHandler.getTankCapacity(tank), fallback);
            }
        }
    }

    private static void addFluidInfo(LookingAtHelper info, FluidStack fluidInTank, int capacity, FluidStack fallback) {
        if (!fluidInTank.isEmpty()) {
            info.addText((Component)MekanismLang.LIQUID.translate(fluidInTank));
        } else if (!fallback.isEmpty()) {
            info.addText((Component)MekanismLang.LIQUID.translate(fallback));
        }
        info.addFluidElement(fluidInTank, capacity);
    }

    private static void displayEnergy(LookingAtHelper info, IStrictEnergyHandler energyHandler) {
        int containers = energyHandler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            info.addEnergyElement(energyHandler.getEnergy(container), energyHandler.getMaxEnergy(container));
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void addInfo(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, @Nullable MultiblockData structure, MultiTypeCapability<HANDLER> capability, Function<MultiblockData, List<TANK>> multiBlockToTanks, LookingAtHelper info, ILangEntry langEntry, MergedChemicalTank.Current matchingCurrent, MergedTank.CurrentType matchingCurrentType) {
        block10: {
            block9: {
                List tanks;
                TileEntityPressurizedTube tube;
                IChemicalHandler handler = (IChemicalHandler)capability.getCapabilityIfLoaded(level, pos, state, tile, null);
                if (handler == null) break block9;
                Object fallback = ((ChemicalStack)handler.getEmptyStack()).getType();
                if (tile instanceof TileEntityPressurizedTube && (tube = (TileEntityPressurizedTube)tile).getTransmitter().hasTransmitterNetwork()) {
                    BoxedChemicalNetwork network = (BoxedChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
                    if (!network.lastChemical.isEmpty() && network.lastChemical.getChemicalType() == ChemicalType.getTypeFor(handler)) {
                        fallback = network.lastChemical.getChemical();
                    }
                }
                if (handler instanceof ProxyChemicalHandler && !(tanks = ((ProxyChemicalHandler)handler).getTanksIfMekanism()).isEmpty()) {
                    for (IChemicalTank tank : tanks) {
                        LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType, fallback);
                    }
                    return;
                }
                if (handler instanceof IMekanismChemicalHandler) {
                    IMekanismChemicalHandler mekHandler = (IMekanismChemicalHandler)handler;
                    for (IChemicalTank tank : mekHandler.getChemicalTanks(null)) {
                        LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType, fallback);
                    }
                } else {
                    for (int i = 0; i < handler.getTanks(); ++i) {
                        LookingAtUtils.addChemicalInfo(info, langEntry, handler.getChemicalInTank(i), handler.getTankCapacity(i), fallback);
                    }
                }
                break block10;
            }
            if (structure == null || !structure.isFormed()) break block10;
            for (IChemicalTank tank : multiBlockToTanks.apply(structure)) {
                LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType, ((ChemicalStack)tank.getEmptyStack()).getType());
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void addChemicalTankInfo(LookingAtHelper info, ILangEntry langEntry, TANK chemicalTank, MergedChemicalTank.Current matchingCurrent, MergedTank.CurrentType matchingCurrentType, CHEMICAL fallback) {
        MergedChemicalTank.Current current;
        MergedTank tank;
        MergedChemicalTank mergedTank;
        if (chemicalTank instanceof ChemicalTankWrapper && ((mergedTank = ((ChemicalTankWrapper)chemicalTank).getMergedTank()) instanceof MergedTank ? (tank = (MergedTank)mergedTank).getCurrentType() != matchingCurrentType : ((current = mergedTank.getCurrent()) == MergedChemicalTank.Current.EMPTY ? matchingCurrent != MergedChemicalTank.Current.GAS : current != matchingCurrent))) {
            return;
        }
        LookingAtUtils.addChemicalInfo(info, langEntry, chemicalTank.getStack(), chemicalTank.getCapacity(), fallback);
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addChemicalInfo(LookingAtHelper info, ILangEntry langEntry, STACK chemicalInTank, long capacity, CHEMICAL fallback) {
        if (!chemicalInTank.isEmpty()) {
            info.addText((Component)langEntry.translate(chemicalInTank.getType()));
        } else if (!fallback.isEmptyType()) {
            info.addText((Component)langEntry.translate(fallback));
        }
        info.addChemicalElement(chemicalInTank, capacity);
    }
}

