/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.jade;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.lookingat.LookingAtHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.neoforged.neoforge.fluids.FluidStack;

public class JadeLookingAtHelper
implements LookingAtHelper {
    static final String CHEMICAL_STACK = "chemical";
    static final String TEXT = "text";
    private final ListTag data = new ListTag();

    @Override
    public void addText(Component text) {
        Optional result = ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)text).result();
        if (result.isPresent()) {
            CompoundTag textData = new CompoundTag();
            textData.put(TEXT, (Tag)result.get());
            this.data.add((Object)textData);
        }
    }

    @Override
    public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
        CompoundTag energyData = new CompoundTag();
        energyData.putString("energy", energy.toString());
        energyData.putString("max", maxEnergy.toString());
        this.data.add((Object)energyData);
    }

    @Override
    public void addFluidElement(FluidStack stored, int capacity) {
        CompoundTag fluidData = new CompoundTag();
        fluidData.put("fluid", (Tag)stored.writeToNBT(new CompoundTag()));
        fluidData.putInt("max", capacity);
        this.data.add((Object)fluidData);
    }

    @Override
    public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
        CompoundTag chemicalData = new CompoundTag();
        chemicalData.put(CHEMICAL_STACK, (Tag)stored.write(new CompoundTag()));
        chemicalData.putLong("max", capacity);
        this.data.add((Object)chemicalData);
    }

    public void finalizeData(CompoundTag data) {
        if (!this.data.isEmpty()) {
            data.put("mekData", (Tag)this.data);
        }
    }
}

