/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.jade;

import mekanism.common.block.BlockBounding;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.LookingAtUtils;
import mekanism.common.integration.lookingat.jade.JadeBuiltinRemover;
import mekanism.common.integration.lookingat.jade.JadeDataProvider;
import mekanism.common.integration.lookingat.jade.JadeEntityDataProvider;
import mekanism.common.integration.lookingat.jade.JadeTooltipRenderer;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;

@WailaPlugin
public class MekanismJadePlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)JadeDataProvider.INSTANCE, BlockEntity.class);
        registration.registerEntityDataProvider((IServerDataProvider)JadeEntityDataProvider.INSTANCE, EntityRobit.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(LookingAtUtils.ENERGY, true);
        registration.addConfig(LookingAtUtils.FLUID, true);
        registration.addConfig(LookingAtUtils.GAS, true);
        registration.addConfig(LookingAtUtils.INFUSE_TYPE, true);
        registration.addConfig(LookingAtUtils.PIGMENT, true);
        registration.addConfig(LookingAtUtils.SLURRY, true);
        registration.registerEntityComponent((IEntityComponentProvider)JadeTooltipRenderer.INSTANCE, EntityRobit.class);
        registration.registerBlockComponent((IBlockComponentProvider)JadeTooltipRenderer.INSTANCE, Block.class);
        registration.registerEntityComponent((IEntityComponentProvider)JadeBuiltinRemover.INSTANCE, EntityRobit.class);
        registration.registerBlockComponent((IBlockComponentProvider)JadeBuiltinRemover.INSTANCE, Block.class);
        registration.addRayTraceCallback((hitResult, accessor, originalAccessor) -> {
            BlockHitResult blockHitResult;
            Level level;
            BlockPos mainPos;
            BlockAccessor target;
            if (accessor instanceof BlockAccessor && (target = (BlockAccessor)accessor).getBlockState().getBlock() instanceof BlockBounding && (mainPos = BlockBounding.getMainBlockPos((BlockGetter)(level = target.getLevel()), (blockHitResult = (BlockHitResult)target.getHitResult()).getBlockPos())) != null) {
                return registration.blockAccessor().from(target).hit(blockHitResult.withPosition(mainPos)).blockState(level.getBlockState(mainPos)).blockEntity(WorldUtils.getTileEntity((BlockGetter)level, mainPos)).build();
            }
            return accessor;
        });
    }
}

