/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;

public class WTHITLookingAtHelper
implements LookingAtHelper,
IData {
    public static final IData.Serializer<WTHITLookingAtHelper> SERIALIZER = buffer -> {
        WTHITLookingAtHelper helper = new WTHITLookingAtHelper();
        int count = buffer.readVarInt();
        for (int i = 0; i < count; ++i) {
            LookingAtElement element;
            LookingAtTypes type = (LookingAtTypes)buffer.readEnum(LookingAtTypes.class);
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case UNKNOWN: {
                    LookingAtElement lookingAtElement = null;
                    break;
                }
                case ENERGY: {
                    LookingAtElement lookingAtElement = new EnergyElement(FloatingLong.readFromBuffer(buffer), FloatingLong.readFromBuffer(buffer));
                    break;
                }
                case FLUID: {
                    LookingAtElement lookingAtElement = new FluidElement(buffer.readFluidStack(), buffer.readVarInt());
                    break;
                }
                case GAS: {
                    LookingAtElement lookingAtElement = new ChemicalElement(ChemicalUtils.readGasStack(buffer), buffer.readVarLong());
                    break;
                }
                case INFUSION: {
                    LookingAtElement lookingAtElement = new ChemicalElement(ChemicalUtils.readInfusionStack(buffer), buffer.readVarLong());
                    break;
                }
                case PIGMENT: {
                    LookingAtElement lookingAtElement = new ChemicalElement(ChemicalUtils.readPigmentStack(buffer), buffer.readVarLong());
                    break;
                }
                case SLURRY: {
                    LookingAtElement lookingAtElement = new ChemicalElement(ChemicalUtils.readSlurryStack(buffer), buffer.readVarLong());
                    break;
                }
                case COMPONENT: {
                    LookingAtElement lookingAtElement = element = buffer.readComponent();
                }
            }
            if (element == null) continue;
            helper.elements.add(element);
        }
        return helper;
    };
    final List<Object> elements = new ArrayList<Object>();

    public void write(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.elements, (buf, object) -> {
            LookingAtTypes type = LookingAtTypes.getType(object);
            buf.writeEnum((Enum)type);
            switch (type) {
                case ENERGY: {
                    EnergyElement energyElement = (EnergyElement)object;
                    energyElement.getEnergy().writeToBuffer((FriendlyByteBuf)buf);
                    energyElement.getMaxEnergy().writeToBuffer((FriendlyByteBuf)buf);
                    break;
                }
                case FLUID: {
                    FluidElement fluidElement = (FluidElement)object;
                    buf.writeFluidStack(fluidElement.getStored());
                    buf.writeVarInt(fluidElement.getCapacity());
                    break;
                }
                case GAS: 
                case INFUSION: 
                case PIGMENT: 
                case SLURRY: {
                    ChemicalElement chemicalElement = (ChemicalElement)object;
                    ChemicalUtils.writeChemicalStack(buf, chemicalElement.getStored());
                    buf.writeVarLong(chemicalElement.getCapacity());
                    break;
                }
                case COMPONENT: {
                    buf.writeComponent((Component)object);
                }
            }
        });
    }

    @Override
    public void addText(Component text) {
        this.elements.add(text);
    }

    @Override
    public void addEnergyElement(FloatingLong energy, FloatingLong maxEnergy) {
        this.elements.add(new EnergyElement(energy, maxEnergy));
    }

    @Override
    public void addFluidElement(FluidStack stored, int capacity) {
        this.elements.add(new FluidElement(stored, capacity));
    }

    @Override
    public void addChemicalElement(ChemicalStack<?> stored, long capacity) {
        this.elements.add(new ChemicalElement(stored, capacity));
    }

    private static enum LookingAtTypes {
        UNKNOWN,
        ENERGY,
        FLUID,
        GAS,
        INFUSION,
        PIGMENT,
        SLURRY,
        COMPONENT;


        public static LookingAtTypes getType(Object element) {
            if (element instanceof Component) {
                return COMPONENT;
            }
            if (element instanceof EnergyElement) {
                return ENERGY;
            }
            if (element instanceof FluidElement) {
                return FLUID;
            }
            if (element instanceof ChemicalElement) {
                ChemicalElement chemicalElement = (ChemicalElement)element;
                return switch (chemicalElement.getChemicalType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ChemicalType.GAS -> GAS;
                    case ChemicalType.INFUSION -> INFUSION;
                    case ChemicalType.PIGMENT -> PIGMENT;
                    case ChemicalType.SLURRY -> SLURRY;
                };
            }
            return UNKNOWN;
        }
    }
}

