/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import moze_intel.projecte.api.codec.NSSCodecHolder;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSGas
extends AbstractNSSTag<Gas> {
    private static final boolean ALLOW_DEFAULT = false;
    public static final Codec<NSSGas> LEGACY_CODEC = NSSGas.createLegacyCodec(MekanismAPI.GAS_REGISTRY, (boolean)false, (String)"GAS|", NSSGas::new);
    public static final MapCodec<NSSGas> EXPLICIT_MAP_CODEC = NSSGas.createExplicitCodec(MekanismAPI.GAS_REGISTRY, (boolean)false, NSSGas::new);
    public static final Codec<NSSGas> EXPLICIT_CODEC = EXPLICIT_MAP_CODEC.codec();
    public static final NSSCodecHolder<NSSGas> CODECS = new NSSCodecHolder("GAS", LEGACY_CODEC, EXPLICIT_CODEC);

    private NSSGas(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSGas createGas(@NotNull GasStack stack) {
        return NSSGas.createGas((Gas)stack.getType());
    }

    @NotNull
    public static NSSGas createGas(@NotNull IGasProvider gasProvider) {
        return NSSGas.createGas((Gas)gasProvider.getChemical());
    }

    @NotNull
    public static NSSGas createGas(@NotNull Gas gas) {
        if (gas.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSGas with an empty gas");
        }
        return NSSGas.createGas(gas.getRegistryName());
    }

    @NotNull
    public static NSSGas createGas(@NotNull ResourceLocation gasID) {
        return new NSSGas(gasID, false);
    }

    @NotNull
    public static NSSGas createTag(@NotNull ResourceLocation tagId) {
        return new NSSGas(tagId, true);
    }

    @NotNull
    public static NSSGas createTag(@NotNull TagKey<Gas> tag) {
        return NSSGas.createTag(tag.location());
    }

    @NotNull
    protected Registry<Gas> getRegistry() {
        return MekanismAPI.GAS_REGISTRY;
    }

    protected NSSGas createNew(Gas gas) {
        return NSSGas.createGas(gas);
    }

    public NSSCodecHolder<NSSGas> codecs() {
        return CODECS;
    }
}

