/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import moze_intel.projecte.api.codec.NSSCodecHolder;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public final class NSSInfuseType
extends AbstractNSSTag<InfuseType> {
    private static final boolean ALLOW_DEFAULT = false;
    public static final Codec<NSSInfuseType> LEGACY_CODEC = NSSInfuseType.createLegacyCodec(MekanismAPI.INFUSE_TYPE_REGISTRY, (boolean)false, (String)"INFUSE_TYPE|", NSSInfuseType::new);
    public static final MapCodec<NSSInfuseType> EXPLICIT_MAP_CODEC = NSSInfuseType.createExplicitCodec(MekanismAPI.INFUSE_TYPE_REGISTRY, (boolean)false, NSSInfuseType::new);
    public static final Codec<NSSInfuseType> EXPLICIT_CODEC = EXPLICIT_MAP_CODEC.codec();
    public static final NSSCodecHolder<NSSInfuseType> CODECS = new NSSCodecHolder("INFUSE_TYPE", LEGACY_CODEC, EXPLICIT_CODEC);

    private NSSInfuseType(@NotNull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @NotNull
    public static NSSInfuseType createInfuseType(@NotNull InfusionStack stack) {
        return NSSInfuseType.createInfuseType((InfuseType)stack.getType());
    }

    @NotNull
    public static NSSInfuseType createInfuseType(@NotNull IInfuseTypeProvider infuseTypeProvider) {
        return NSSInfuseType.createInfuseType((InfuseType)infuseTypeProvider.getChemical());
    }

    @NotNull
    public static NSSInfuseType createInfuseType(@NotNull InfuseType infuseType) {
        if (infuseType.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSInfuseType with an empty infuse type");
        }
        return NSSInfuseType.createInfuseType(infuseType.getRegistryName());
    }

    @NotNull
    public static NSSInfuseType createInfuseType(@NotNull ResourceLocation infuseTypeID) {
        return new NSSInfuseType(infuseTypeID, false);
    }

    @NotNull
    public static NSSInfuseType createTag(@NotNull ResourceLocation tagId) {
        return new NSSInfuseType(tagId, true);
    }

    @NotNull
    public static NSSInfuseType createTag(@NotNull TagKey<InfuseType> tag) {
        return NSSInfuseType.createTag(tag.location());
    }

    @NotNull
    protected Registry<InfuseType> getRegistry() {
        return MekanismAPI.INFUSE_TYPE_REGISTRY;
    }

    protected NSSInfuseType createNew(InfuseType infuseType) {
        return NSSInfuseType.createInfuseType(infuseType);
    }

    public NSSCodecHolder<NSSInfuseType> codecs() {
        return CODECS;
    }
}

