/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSInfuseType;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class MetallurgicInfuserRecipeMapper
extends TypedMekanismRecipeMapper<MetallurgicInfuserRecipe> {
    public MetallurgicInfuserRecipeMapper() {
        super(MetallurgicInfuserRecipe.class, MekanismRecipeType.METALLURGIC_INFUSING);
    }

    public String getName() {
        return "MekMetallurgicInfuser";
    }

    public String getDescription() {
        return "Maps Mekanism metallurgic infuser recipes.";
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, MetallurgicInfuserRecipe recipe) {
        boolean handled = false;
        List<@NotNull TYPE> infuseTypeRepresentations = recipe.getChemicalInput().getRepresentations();
        List<@NotNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        for (InfusionStack infuseTypeRepresentation : infuseTypeRepresentations) {
            NSSInfuseType nssInfuseType = NSSInfuseType.createInfuseType(infuseTypeRepresentation);
            for (ItemStack itemRepresentation : itemRepresentations) {
                ItemStack output = recipe.getOutput(itemRepresentation, infuseTypeRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssInfuseType, infuseTypeRepresentation.getAmount());
                ingredientHelper.put(itemRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

