/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class PressurizedReactionRecipeMapper
extends TypedMekanismRecipeMapper<PressurizedReactionRecipe> {
    public PressurizedReactionRecipeMapper() {
        super(PressurizedReactionRecipe.class, MekanismRecipeType.REACTION);
    }

    public String getName() {
        return "MekPressurizedReaction";
    }

    public String getDescription() {
        return "Maps Mekanism pressurized reaction recipes.";
    }

    public boolean isAvailable() {
        return false;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, PressurizedReactionRecipe recipe) {
        boolean handled = false;
        List<@NotNull TYPE> itemRepresentations = recipe.getInputSolid().getRepresentations();
        List<@NotNull TYPE> fluidRepresentations = recipe.getInputFluid().getRepresentations();
        List<@NotNull TYPE> gasRepresentations = recipe.getInputGas().getRepresentations();
        for (ItemStack itemRepresentation : itemRepresentations) {
            NSSItem nssItem = NSSItem.createItem((ItemStack)itemRepresentation);
            for (FluidStack fluidRepresentation : fluidRepresentations) {
                NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
                for (GasStack gasRepresentation : gasRepresentations) {
                    NSSGas nssGas = NSSGas.createGas(gasRepresentation);
                    PressurizedReactionRecipe.PressurizedReactionRecipeOutput output = recipe.getOutput(itemRepresentation, fluidRepresentation, gasRepresentation);
                    ItemStack itemOutput = output.item();
                    GasStack gasOutput = output.gas();
                    IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.getCount());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssGas, gasRepresentation.getAmount());
                    if (itemOutput.isEmpty()) {
                        if (gasOutput.isEmpty() || !ingredientHelper.addAsConversion(gasOutput)) continue;
                        handled = true;
                        continue;
                    }
                    if (gasOutput.isEmpty()) {
                        if (!ingredientHelper.addAsConversion(itemOutput)) continue;
                        handled = true;
                        continue;
                    }
                    NSSItem nssItemOutput = NSSItem.createItem((ItemStack)itemOutput);
                    NSSGas nssGasOutput = NSSGas.createGas(gasOutput);
                    ingredientHelper.put((NormalizedSimpleStack)nssGasOutput, -gasOutput.getAmount());
                    if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssItemOutput, itemOutput.getCount())) {
                        handled = true;
                    }
                    ingredientHelper.resetHelper();
                    ingredientHelper.put((NormalizedSimpleStack)nssItem, itemRepresentation.getCount());
                    ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssGas, gasRepresentation.getAmount());
                    ingredientHelper.put((NormalizedSimpleStack)nssItemOutput, -itemOutput.getCount());
                    if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssGasOutput, gasOutput.getAmount())) continue;
                    handled = true;
                }
            }
        }
        return handled;
    }
}

