/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.processors;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.Upgrade;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.UpgradeUtils;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.NotNull;

@NBTProcessor
public class MekanismContentsProcessor
implements INBTProcessor {
    public String getName() {
        return "MekanismContentsProcessor";
    }

    public String getDescription() {
        return "Increases the EMC value of any Mekanism items by the value of the stored or installed contents.";
    }

    public long recalculateEMC(@NotNull ItemInfo info, long currentEMC) throws ArithmeticException {
        Optional existingUpgrades;
        IEMCProxy emcProxy = IEMCProxy.INSTANCE;
        ItemStack stack = info.createStack();
        currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, ContainerType.ITEM.getAttachmentContainersIfPresent((IAttachmentHolder)stack));
        Optional<AbstractPersonalStorageItemInventory> personalStorage = PersonalStorageManager.getInventoryIfPresent(stack);
        if (personalStorage.isPresent()) {
            currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, personalStorage.get().getInventorySlots(null));
        }
        if ((existingUpgrades = stack.getExistingData(MekanismAttachmentTypes.UPGRADES)).isPresent()) {
            UpgradeAware upgradeAware = (UpgradeAware)existingUpgrades.get();
            for (Map.Entry<Upgrade, Integer> entry : upgradeAware.getUpgrades().entrySet()) {
                currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, UpgradeUtils.getStack(entry.getKey(), entry.getValue()));
            }
            currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, upgradeAware.getInventorySlots(null));
        }
        for (IModule<?> module : IModuleHelper.INSTANCE.loadAll(stack)) {
            ItemStack moduleStack = module.getData().getItemProvider().getItemStack(module.getInstalledCount());
            currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, moduleStack);
        }
        return currentEMC;
    }

    private static long addEmc(IEMCProxy emcProxy, long currentEMC, List<IInventorySlot> slots) throws ArithmeticException {
        for (IInventorySlot slot : slots) {
            if (slot.isEmpty()) continue;
            currentEMC = MekanismContentsProcessor.addEmc(emcProxy, currentEMC, slot.getStack());
        }
        return currentEMC;
    }

    private static long addEmc(IEMCProxy emcProxy, long currentEMC, ItemStack stack) throws ArithmeticException {
        long itemEmc = emcProxy.getValue(stack);
        if (itemEmc > 0L) {
            long stackEmc = Math.multiplyExact(itemEmc, stack.getCount());
            currentEMC = Math.addExact(currentEMC, stackEmc);
        }
        return currentEMC;
    }
}

