/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedIntValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedWindowData {
    public static final SelectedWindowData UNSPECIFIED = new SelectedWindowData(WindowType.UNSPECIFIED);
    @NotNull
    public final WindowType type;
    public final byte extraData;

    public SelectedWindowData(@NotNull WindowType type) {
        this(type, 0);
    }

    public SelectedWindowData(@NotNull WindowType type, byte extraData) {
        this.type = Objects.requireNonNull(type);
        this.extraData = this.type.isValid(extraData) ? extraData : (byte)0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedWindowData other = (SelectedWindowData)o;
        return this.extraData == other.extraData && this.type == other.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.extraData});
    }

    public void updateLastPosition(int x, int y, boolean pinned) {
        CachedWindowPosition cachedPosition;
        String saveName = this.type.getSaveName(this.extraData);
        if (saveName != null && (cachedPosition = MekanismConfig.client.lastWindowPositions.get(saveName)) != null) {
            CachedBooleanValue cachedPinned;
            CachedIntValue cachedY;
            boolean changed = false;
            CachedIntValue cachedX = cachedPosition.x();
            if (cachedX.get() != x) {
                cachedX.set(x);
                changed = true;
            }
            if ((cachedY = cachedPosition.y()).get() != y) {
                cachedY.set(y);
                changed = true;
            }
            if ((cachedPinned = cachedPosition.pinned) != null && cachedPinned.get() != pinned) {
                cachedPinned.set(pinned);
                changed = true;
            }
            if (changed) {
                MekanismConfig.client.save();
            }
        }
    }

    public boolean wasPinned() {
        return this.getLastPosition().pinned();
    }

    public WindowPosition getLastPosition() {
        CachedWindowPosition cachedPosition;
        String saveName = this.type.getSaveName(this.extraData);
        if (saveName != null && (cachedPosition = MekanismConfig.client.lastWindowPositions.get(saveName)) != null) {
            return new WindowPosition(cachedPosition.x().get(), cachedPosition.y().get(), cachedPosition.pinned() != null && cachedPosition.pinned().get());
        }
        return new WindowPosition(Integer.MAX_VALUE, Integer.MAX_VALUE, false);
    }

    public static enum WindowType {
        COLOR("color", false),
        CONFIRMATION("confirmation", false),
        CRAFTING("crafting", true, 3),
        MEKA_SUIT_HELMET("mekaSuitHelmet", false),
        RENAME("rename", false),
        SKIN_SELECT("skinSelect", false),
        SIDE_CONFIG("sideConfig", true),
        TRANSPORTER_CONFIG("transporterConfig", true),
        UPGRADE("upgrade", true),
        UNSPECIFIED(null, false);

        @Nullable
        private final String saveName;
        private final boolean canPin;
        private final byte maxData;

        private WindowType(String saveName, boolean canPin) {
            this(saveName, canPin, 1);
        }

        private WindowType(String saveName, boolean canPin, byte maxData) {
            this.saveName = saveName;
            this.maxData = maxData;
            this.canPin = canPin;
        }

        @Nullable
        String getSaveName(byte extraData) {
            return this.maxData == 1 ? this.saveName : this.saveName + extraData;
        }

        public List<String> getSavePaths() {
            if (this.saveName == null) {
                return Collections.emptyList();
            }
            if (this.maxData == 1) {
                return Collections.singletonList(this.saveName);
            }
            ArrayList<String> savePaths = new ArrayList<String>();
            for (int i = 0; i < this.maxData; ++i) {
                savePaths.add(this.saveName + i);
            }
            return savePaths;
        }

        public boolean canPin() {
            return this.canPin;
        }

        public boolean isValid(byte extraData) {
            return extraData >= 0 && extraData < this.maxData;
        }
    }

    public record CachedWindowPosition(CachedIntValue x, CachedIntValue y, @Nullable CachedBooleanValue pinned) {
    }

    public record WindowPosition(int x, int y, boolean pinned) {
    }
}

