/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.Collections;
import java.util.List;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class FrequencyItemContainer<FREQ extends Frequency>
extends MekanismItemContainer {
    private List<FREQ> publicCache = Collections.emptyList();
    private List<FREQ> privateCache = Collections.emptyList();
    private List<FREQ> trustedCache = Collections.emptyList();
    private FrequencyAware<FREQ> frequencyAware;

    protected FrequencyItemContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(type, id, inv, hand, stack);
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Nullable
    public FREQ getFrequency() {
        return this.frequencyAware == null ? null : (FREQ)this.frequencyAware.getFrequency();
    }

    public List<FREQ> getPublicCache() {
        return this.publicCache;
    }

    public List<FREQ> getPrivateCache() {
        return this.privateCache;
    }

    public List<FREQ> getTrustedCache() {
        return this.trustedCache;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        this.frequencyAware = (FrequencyAware)this.stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE);
        FrequencyType frequencyType = this.frequencyAware.getFrequencyType();
        this.track(SyncableFrequency.create(this.frequencyAware));
        if (this.isRemote()) {
            this.track(SyncableFrequencyList.create(frequencyType, this::getPublicCache, value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, this::getPrivateCache, value -> {
                this.privateCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, this::getTrustedCache, value -> {
                this.trustedCache = value;
            }));
        } else {
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(null, SecurityMode.PUBLIC).getFrequencies(), value -> {
                this.publicCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(this.getPlayerUUID(), SecurityMode.PRIVATE).getFrequencies(), value -> {
                this.privateCache = value;
            }));
            this.track(SyncableFrequencyList.create(frequencyType, () -> frequencyType.getManager(this.getPlayerUUID(), SecurityMode.TRUSTED).getFrequencies(), value -> {
                this.trustedCache = value;
            }));
        }
    }
}

