/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class MekanismItemContainer
extends MekanismContainer {
    protected final InteractionHand hand;
    protected ItemStack stack;

    protected MekanismItemContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(type, id, inv);
        this.hand = hand;
        this.stack = stack;
        if (!stack.isEmpty()) {
            this.addContainerTrackers();
        }
        this.addSlotsAndOpen();
    }

    protected void addContainerTrackers() {
        Item item = this.stack.getItem();
        if (item instanceof IItemContainerTracker) {
            IItemContainerTracker containerTracker = (IItemContainerTracker)item;
            containerTracker.addContainerTrackers(this, this.stack);
        }
    }

    @Override
    protected void addInventorySlots(@NotNull Inventory inv) {
        super.addInventorySlots(inv);
        if (this.offhandSlots.isEmpty()) {
            this.track(SyncableItemStack.create(() -> ((Player)inv.player).getOffhandItem(), item -> {
                inv.player.setItemSlot(EquipmentSlot.OFFHAND, item);
                if (this.hand == InteractionHand.OFF_HAND && this.stack.is(item.getItem())) {
                    this.stack = item;
                }
            }));
        }
        if (this.hotBarSlots.isEmpty()) {
            if (this.hand == InteractionHand.MAIN_HAND) {
                this.track(SyncableItemStack.create(() -> ((Player)inv.player).getMainHandItem(), item -> {
                    inv.player.setItemSlot(EquipmentSlot.MAINHAND, item);
                    if (this.stack.is(item.getItem())) {
                        this.stack = item;
                    }
                }));
            }
            for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
                if (i == inv.selected && this.hand == InteractionHand.MAIN_HAND) continue;
                int index = i;
                this.track(SyncableItemStack.create(() -> inv.getItem(index), item -> inv.setItem(index, item)));
            }
        }
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        return IItemSecurityUtils.INSTANCE.canAccess(player, this.stack);
    }

    public boolean stillValid(@NotNull Player player) {
        return !this.stack.isEmpty() && player.getItemInHand(this.hand).is(this.stack.getItem());
    }

    public static interface IItemContainerTracker {
        public void addContainerTrackers(MekanismContainer var1, ItemStack var2);
    }
}

