/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.ClientSidePersonalStorageInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PersonalStorageItemContainer
extends MekanismItemContainer {
    private final AbstractPersonalStorageItemInventory itemInventory;

    public PersonalStorageItemContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack, boolean isRemote) {
        super(MekanismContainerTypes.PERSONAL_STORAGE_ITEM, id, inv, hand, stack);
        this.itemInventory = isRemote ? new ClientSidePersonalStorageInventory() : PersonalStorageManager.getInventoryFor(stack).orElseThrow(() -> new IllegalStateException("Inventory not available"));
        super.addSlotsAndOpen();
    }

    @Override
    protected void addSlotsAndOpen() {
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        List<IInventorySlot> inventorySlots = this.itemInventory.getInventorySlots(null);
        for (IInventorySlot inventorySlot : inventorySlots) {
            Slot containerSlot = inventorySlot.createContainerSlot();
            if (containerSlot == null) continue;
            this.addSlot(containerSlot);
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Override
    protected int getInventoryYOffset() {
        return 140;
    }

    @Override
    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        if (index == inv.selected && this.hand == InteractionHand.MAIN_HAND) {
            return new HotBarSlot((Container)inv, index, x, y){

                public boolean mayPickup(@NotNull Player player) {
                    return false;
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    public void clicked(int slotId, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        if (clickType == ClickType.SWAP) {
            if (this.hand == InteractionHand.OFF_HAND && dragType == 40) {
                return;
            }
            if (this.hand == InteractionHand.MAIN_HAND && dragType >= 0 && dragType < Inventory.getSelectionSize() && !((HotBarSlot)this.hotBarSlots.get(dragType)).mayPickup(player)) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }
}

