/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import mekanism.api.security.IItemSecurityUtils;
import mekanism.common.attachments.PortableQIODashboardInventory;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketItemGuiInteract;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PortableQIODashboardContainer
extends QIOItemViewerContainer {
    protected final InteractionHand hand;
    protected ItemStack stack;

    private PortableQIODashboardContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack, boolean remote, IQIOCraftingWindowHolder craftingWindowHolder) {
        super(MekanismContainerTypes.PORTABLE_QIO_DASHBOARD, id, inv, remote, craftingWindowHolder);
        this.hand = hand;
        this.stack = stack;
        this.addSlotsAndOpen();
    }

    public PortableQIODashboardContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack, boolean remote) {
        this(id, inv, hand, stack, remote, ((PortableQIODashboardInventory)stack.getData(MekanismAttachmentTypes.QIO_DASHBOARD)).updateLevel(inv.player.level()));
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public PortableQIODashboardContainer recreate() {
        PortableQIODashboardContainer container = new PortableQIODashboardContainer(this.containerId, this.inv, this.hand, this.stack, true, this.craftingWindowHolder);
        this.sync(container);
        return container;
    }

    @Override
    protected void closeInventory(@NotNull Player player) {
        super.closeInventory(player);
        IQIOCraftingWindowHolder iQIOCraftingWindowHolder = this.craftingWindowHolder;
        if (iQIOCraftingWindowHolder instanceof PortableQIODashboardInventory) {
            PortableQIODashboardInventory inventory = (PortableQIODashboardInventory)iQIOCraftingWindowHolder;
            inventory.updateLevel(null);
        }
    }

    @Override
    protected void addInventorySlots(@NotNull Inventory inv) {
        super.addInventorySlots(inv);
        if (this.offhandSlots.isEmpty()) {
            this.track(SyncableItemStack.create(() -> ((Player)inv.player).getOffhandItem(), item -> {
                inv.player.setItemSlot(EquipmentSlot.OFFHAND, item);
                if (this.hand == InteractionHand.OFF_HAND && this.stack.is(item.getItem())) {
                    this.stack = item;
                }
            }));
        }
    }

    @Override
    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        if (index == inv.selected && this.hand == InteractionHand.MAIN_HAND) {
            return new HotBarSlot((Container)inv, index, x, y){

                public boolean mayPickup(@NotNull Player player) {
                    return false;
                }

                public void set(@NotNull ItemStack item) {
                    super.set(item);
                    if (PortableQIODashboardContainer.this.stack.is(item.getItem())) {
                        PortableQIODashboardContainer.this.stack = item;
                    }
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    public void clicked(int slotId, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        if (clickType == ClickType.SWAP) {
            if (this.hand == InteractionHand.OFF_HAND && dragType == 40) {
                return;
            }
            if (this.hand == InteractionHand.MAIN_HAND && dragType >= 0 && dragType < Inventory.getSelectionSize() && !((HotBarSlot)this.hotBarSlots.get(dragType)).mayPickup(player)) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        return IItemSecurityUtils.INSTANCE.canAccess(player, this.stack);
    }

    public boolean stillValid(@NotNull Player player) {
        return !this.stack.isEmpty() && player.getItemInHand(this.hand).is(this.stack.getItem());
    }

    @Override
    public boolean shiftClickIntoFrequency() {
        return !this.stack.isEmpty() && (Boolean)this.stack.getData(MekanismAttachmentTypes.INSERT_INTO_FREQUENCY) != false;
    }

    @Override
    public void toggleTargetDirection() {
        PacketUtils.sendToServer(new PacketItemGuiInteract(PacketItemGuiInteract.ItemGuiInteraction.TARGET_DIRECTION_BUTTON, this.hand));
    }
}

