/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import mekanism.api.Action;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class InsertableSlot
extends Slot
implements IInsertableSlot {
    public InsertableSlot(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public int getMaxStackSize(ItemStack stack) {
        return Math.min(this.getMaxStackSize(), stack.getMaxStackSize());
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, Action action) {
        if (stack.isEmpty() || !this.mayPlace(stack)) {
            return stack;
        }
        ItemStack current = this.getItem();
        int needed = this.getMaxStackSize(stack) - current.getCount();
        if (needed <= 0) {
            return stack;
        }
        if (current.isEmpty() || ItemHandlerHelper.canItemStacksStack((ItemStack)current, (ItemStack)stack)) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (action.execute()) {
                this.set(stack.copyWithCount(current.getCount() + toAdd));
            }
            return stack.copyWithCount(stack.getCount() - toAdd);
        }
        return stack;
    }
}

