/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import java.util.List;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualCraftingOutputSlot
extends VirtualInventoryContainerSlot
implements IHasExtraData {
    @NotNull
    private final QIOCraftingWindow craftingWindow;
    private boolean canCraft;
    private int amountCrafted;

    public VirtualCraftingOutputSlot(BasicInventorySlot slot, @Nullable SlotOverlay slotOverlay, Consumer<ItemStack> uncheckedSetter, @NotNull QIOCraftingWindow craftingWindow) {
        super(slot, craftingWindow.getWindowData(), slotOverlay, uncheckedSetter);
        this.craftingWindow = craftingWindow;
    }

    @Override
    public boolean canMergeWith(@NotNull ItemStack stack) {
        return false;
    }

    @Override
    public boolean mayPlace(@NotNull ItemStack stack) {
        return false;
    }

    @Override
    protected boolean allowPartialRemoval() {
        return false;
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, Action action) {
        return stack;
    }

    @Override
    @NotNull
    public ItemStack remove(int amount) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack extracted = this.getInventorySlot().getStack().copy();
        this.amountCrafted += extracted.getCount();
        return extracted;
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void onSwapCraft(int numItemsCrafted) {
        this.amountCrafted += numItemsCrafted;
    }

    public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        ItemStack result = this.craftingWindow.performCraft(player, stack, this.amountCrafted);
        this.amountCrafted = 0;
    }

    @Override
    public boolean mayPickup(@NotNull Player player) {
        if (player.level().isClientSide || !(player instanceof ServerPlayer)) {
            return this.canCraft && super.mayPickup(player);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        return this.craftingWindow.canViewRecipe(serverPlayer) && super.mayPickup(player);
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.canCraft ? super.getItem() : ItemStack.EMPTY;
    }

    @Override
    public boolean hasItem() {
        return this.canCraft && super.hasItem();
    }

    @Override
    @NotNull
    public ItemStack getStackToRender() {
        return this.canCraft ? super.getStackToRender() : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack shiftClickSlot(@NotNull Player player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        this.craftingWindow.performCraft(player, hotBarSlots, mainInventorySlots);
        return ItemStack.EMPTY;
    }

    @Override
    public void addTrackers(Player player, Consumer<ISyncableData> tracker) {
        if (player.level().isClientSide || !(player instanceof ServerPlayer)) {
            tracker.accept(SyncableBoolean.create(() -> this.canCraft, value -> {
                this.canCraft = value;
            }));
        } else {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            tracker.accept(SyncableBoolean.create(() -> {
                this.canCraft = this.craftingWindow.canViewRecipe(serverPlayer);
                return this.canCraft;
            }, value -> {
                this.canCraft = value;
            }));
        }
    }
}

