/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.FluidStackPropertyData;
import mekanism.common.network.to_client.container.property.IntPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SyncableFluidStack
implements ISyncableData {
    @NotNull
    private FluidStack lastKnownValue = FluidStack.EMPTY;
    private final Supplier<@NotNull FluidStack> getter;
    private final Consumer<@NotNull FluidStack> setter;

    public static SyncableFluidStack create(@NotNull IExtendedFluidTank handler) {
        return SyncableFluidStack.create(handler, false);
    }

    public static SyncableFluidStack create(IExtendedFluidTank handler, boolean isClient) {
        return SyncableFluidStack.create(() -> ((IExtendedFluidTank)handler).getFluid(), isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncableFluidStack create(Supplier<@NotNull FluidStack> getter, Consumer<@NotNull FluidStack> setter) {
        return new SyncableFluidStack(getter, setter);
    }

    private SyncableFluidStack(Supplier<@NotNull FluidStack> getter, Consumer<@NotNull FluidStack> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @NotNull
    public FluidStack get() {
        return this.getter.get();
    }

    public void set(@NotNull FluidStack value) {
        this.setter.accept(value);
    }

    public void set(int amount) {
        FluidStack fluid = this.get();
        if (!fluid.isEmpty()) {
            this.set(fluid.copyWithAmount(amount));
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        FluidStack value = this.get();
        boolean sameFluid = value.isFluidEqual(this.lastKnownValue);
        if (!sameFluid || value.getAmount() != this.lastKnownValue.getAmount()) {
            this.lastKnownValue = value.copy();
            return sameFluid ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new IntPropertyData(property, this.get().getAmount());
        }
        return new FluidStackPropertyData(property, this.get().copy());
    }
}

