/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.container.property.ByteArrayPropertyData;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import org.jetbrains.annotations.Nullable;

public class SyncableFrequency<FREQUENCY extends Frequency>
implements ISyncableData {
    private final FrequencyType<FREQUENCY> type;
    private final Supplier<FREQUENCY> getter;
    private final Consumer<FREQUENCY> setter;
    private int lastKnownHashCode;

    public static <FREQUENCY extends Frequency> SyncableFrequency<FREQUENCY> create(FrequencyAware<FREQUENCY> frequencyAware) {
        return SyncableFrequency.create(frequencyAware.getFrequencyType(), frequencyAware::getFrequency, frequencyAware::setFrequency);
    }

    public static <FREQUENCY extends Frequency> SyncableFrequency<FREQUENCY> create(FrequencyType<FREQUENCY> type, Supplier<FREQUENCY> getter, Consumer<FREQUENCY> setter) {
        return new SyncableFrequency<FREQUENCY>(type, getter, setter);
    }

    private SyncableFrequency(FrequencyType<FREQUENCY> type, Supplier<FREQUENCY> getter, Consumer<FREQUENCY> setter) {
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Nullable
    public FREQUENCY get() {
        return (FREQUENCY)((Frequency)this.getter.get());
    }

    public void set(byte[] rawData) {
        this.setter.accept((Frequency)PacketUtils.read(rawData, buffer -> (Frequency)buffer.readNullable(this.type::create)));
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        int valueHashCode;
        FREQUENCY value = this.get();
        int n = valueHashCode = value == null ? 0 : ((Frequency)value).getSyncHash();
        if (this.lastKnownHashCode == valueHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valueHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }

    @Override
    public ByteArrayPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        byte[] rawData = FriendlyByteBufUtil.writeCustomData(buffer -> buffer.writeNullable(this.get(), (buf, val) -> val.write((FriendlyByteBuf)buf)));
        return new ByteArrayPropertyData(property, rawData);
    }
}

