/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.IntPropertyData;
import net.minecraft.core.Registry;
import org.jetbrains.annotations.NotNull;

public class SyncableRegistryEntry<V>
implements ISyncableData {
    private final Supplier<@NotNull V> getter;
    private final Consumer<@NotNull V> setter;
    private final Registry<V> registry;
    private V lastKnownValue;

    public static <V> SyncableRegistryEntry<V> create(Registry<V> registry, Supplier<@NotNull V> getter, Consumer<@NotNull V> setter) {
        return new SyncableRegistryEntry<V>(registry, getter, setter);
    }

    private SyncableRegistryEntry(Registry<V> registry, Supplier<@NotNull V> getter, Consumer<@NotNull V> setter) {
        this.registry = registry;
        this.getter = getter;
        this.setter = setter;
    }

    @NotNull
    public V get() {
        return this.getter.get();
    }

    public void setFromId(int id) {
        Object value = this.registry.byId(id);
        if (value != null) {
            this.setter.accept(value);
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        V oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public IntPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        V value = this.get();
        int id = this.registry.getId(value);
        if (id == -1) {
            throw new IllegalArgumentException("Can't find id for '" + value + "' in map " + this.registry);
        }
        return new IntPropertyData(property, id);
    }
}

