/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.list;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.container.property.ByteArrayPropertyData;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SyncableCollection<TYPE>
implements ISyncableData {
    private final Supplier<? extends @NotNull Collection<TYPE>> getter;
    private final Consumer<@NotNull Collection<TYPE>> setter;
    private int lastKnownHashCode;

    protected SyncableCollection(Supplier<? extends @NotNull Collection<TYPE>> getter, Consumer<@NotNull Collection<TYPE>> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @NotNull
    public Collection<TYPE> get() {
        return this.getRaw();
    }

    @NotNull
    protected Collection<TYPE> getRaw() {
        return this.getter.get();
    }

    protected int getValueHashCode() {
        return this.getRaw().hashCode();
    }

    public void set(byte[] rawData) {
        this.setter.accept((Collection)PacketUtils.read(rawData, this::deserializeList));
    }

    protected abstract Collection<TYPE> deserializeList(FriendlyByteBuf var1);

    protected abstract void serializeListElement(FriendlyByteBuf var1, TYPE var2);

    @Override
    public ByteArrayPropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        byte[] rawData = FriendlyByteBufUtil.writeCustomData(buffer -> buffer.writeCollection(this.getRaw(), this::serializeListElement));
        return new ByteArrayPropertyData(property, rawData);
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        int valuesHashCode = this.getValueHashCode();
        if (this.lastKnownHashCode == valuesHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valuesHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }
}

