/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.list;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.list.SyncableList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.NotNull;

public class SyncableResourceKeyList<V>
extends SyncableList<ResourceKey<V>> {
    private final ResourceKey<? extends Registry<V>> registry;

    public static <V> SyncableResourceKeyList<V> create(ResourceKey<? extends Registry<V>> registry, Supplier<@NotNull List<ResourceKey<V>>> getter, Consumer<@NotNull List<ResourceKey<V>>> setter) {
        return new SyncableResourceKeyList<V>(registry, getter, setter);
    }

    private SyncableResourceKeyList(ResourceKey<? extends Registry<V>> registry, Supplier<@NotNull List<ResourceKey<V>>> getter, Consumer<@NotNull List<ResourceKey<V>>> setter) {
        super(getter, setter);
        this.registry = registry;
    }

    @Override
    protected List<ResourceKey<V>> deserializeList(FriendlyByteBuf buffer) {
        return buffer.readList(buf -> buf.readResourceKey(this.registry));
    }

    @Override
    protected void serializeListElement(FriendlyByteBuf buffer, ResourceKey<V> value) {
        buffer.writeResourceKey(value);
    }
}

