/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.tile;

import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismTileContainer<TILE extends TileEntityMekanism>
extends MekanismContainer {
    private VirtualInventoryContainerSlot upgradeSlot;
    private VirtualInventoryContainerSlot upgradeOutputSlot;
    @NotNull
    protected final TILE tile;

    public MekanismTileContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv, @NotNull TILE tile) {
        super(type, id, inv);
        this.tile = tile;
        this.addContainerTrackers();
        this.addSlotsAndOpen();
    }

    protected void addContainerTrackers() {
        ((TileEntityMekanism)this.tile).addContainerTrackers(this);
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        Level level = this.tile.getLevel();
        if (level == null) {
            return false;
        }
        return IBlockSecurityUtils.INSTANCE.canAccess(player, level, this.tile.getBlockPos(), (BlockEntity)this.tile);
    }

    @Override
    protected void openInventory(@NotNull Inventory inv) {
        super.openInventory(inv);
        ((TileEntityMekanism)this.tile).open(inv.player);
    }

    @Override
    protected void closeInventory(@NotNull Player player) {
        super.closeInventory(player);
        ((TileEntityMekanism)this.tile).close(player);
    }

    public boolean stillValid(@NotNull Player player) {
        return ((TileEntityMekanism)this.tile).hasGui() && !this.tile.isRemoved() && WorldUtils.isBlockLoaded((BlockGetter)this.tile.getLevel(), this.tile.getBlockPos());
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        if (this instanceof IEmptyContainer) {
            return;
        }
        if (((TileEntityMekanism)this.tile).supportsUpgrades()) {
            this.upgradeSlot = ((TileEntityMekanism)this.tile).getComponent().getUpgradeSlot().createContainerSlot();
            this.addSlot(this.upgradeSlot);
            this.upgradeOutputSlot = ((TileEntityMekanism)this.tile).getComponent().getUpgradeOutputSlot().createContainerSlot();
            this.addSlot(this.upgradeOutputSlot);
        }
        if (((TileEntityMekanism)this.tile).hasInventory()) {
            List<IInventorySlot> inventorySlots = ((TileEntityMekanism)this.tile).getInventorySlots(null);
            for (IInventorySlot inventorySlot : inventorySlots) {
                Slot containerSlot = inventorySlot.createContainerSlot();
                if (containerSlot == null) continue;
                this.addSlot(containerSlot);
            }
        }
    }

    @Nullable
    public VirtualInventoryContainerSlot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    @Nullable
    public VirtualInventoryContainerSlot getUpgradeOutputSlot() {
        return this.upgradeOutputSlot;
    }
}

