/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.slot.chemical.MergedChemicalInventorySlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridInventorySlot
extends MergedChemicalInventorySlot<MergedTank>
implements IFluidHandlerSlot {
    private boolean isDraining;
    private boolean isFilling;

    public static HybridInventorySlot inputOrDrain(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> fluidInsertPredicate = FluidInventorySlot.getInputPredicate(mergedTank.getFluidTank());
        Predicate<@NotNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getGasTank(), Capabilities.GAS);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getInfusionTank(), Capabilities.INFUSION);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getPigmentTank(), Capabilities.PIGMENT);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(mergedTank.getSlurryTank(), Capabilities.SLURRY);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> insertPredicate = (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedTank.CurrentType.FLUID -> fluidInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> fluidInsertPredicate.test((ItemStack)stack) || gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, listener, x, y);
    }

    public static HybridInventorySlot outputOrFill(MergedTank mergedTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(mergedTank, "Merged tank cannot be null");
        Predicate<@NotNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getGasTank(), Capabilities.GAS);
        Predicate<@NotNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getInfusionTank(), Capabilities.INFUSION);
        Predicate<@NotNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getPigmentTank(), Capabilities.PIGMENT);
        Predicate<@NotNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(mergedTank.getSlurryTank(), Capabilities.SLURRY);
        Predicate<@NotNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getGasTank(), Capabilities.GAS, stack);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getInfusionTank(), Capabilities.INFUSION, stack);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getPigmentTank(), Capabilities.PIGMENT, stack);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(mergedTank.getSlurryTank(), Capabilities.SLURRY, stack);
        return new HybridInventorySlot(mergedTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return switch (mergedTank.getCurrentType()) {
                default -> throw new IncompatibleClassChangeError();
                case MergedTank.CurrentType.FLUID -> true;
                case MergedTank.CurrentType.GAS -> gasExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.INFUSION -> infusionExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.PIGMENT -> pigmentExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.SLURRY -> slurryExtractPredicate.test((ItemStack)stack);
                case MergedTank.CurrentType.EMPTY -> gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
            };
        }, (stack, automationType) -> switch (mergedTank.getCurrentType()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedTank.CurrentType.FLUID -> {
                if (automationType == AutomationType.INTERNAL) {
                    yield true;
                }
                yield false;
            }
            case MergedTank.CurrentType.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedTank.CurrentType.EMPTY -> automationType == AutomationType.INTERNAL && Capabilities.FLUID.hasCapability((ItemStack)stack) ? true : gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, listener, x, y);
    }

    private HybridInventorySlot(MergedTank mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(mergedTank, canExtract, canInsert, listener, x, y);
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return ((MergedTank)this.mergedTank).getFluidTank();
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.isDraining) {
            nbt.putBoolean("draining", true);
        }
        if (this.isFilling) {
            nbt.putBoolean("filling", true);
        }
        return nbt;
    }

    @Override
    public boolean isCompatible(@NotNull IInventorySlot o) {
        if (super.isCompatible(o)) {
            HybridInventorySlot other = (HybridInventorySlot)o;
            return this.isDraining == other.isDraining && this.isFilling == other.isFilling;
        }
        return false;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag nbt) {
        this.isDraining = nbt.getBoolean("draining");
        this.isFilling = nbt.getBoolean("filling");
        super.deserializeNBT(nbt);
    }
}

