/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public interface IFluidHandlerSlot
extends IInventorySlot {
    public IExtendedFluidTank getFluidTank();

    public boolean isDraining();

    public boolean isFilling();

    public void setDraining(boolean var1);

    public void setFilling(boolean var1);

    default public void handleTank(IInventorySlot outputSlot, IFluidContainerManager.ContainerEditMode editMode) {
        if (!this.isEmpty()) {
            ItemStack stack;
            IFluidHandlerItem fluidHandlerItem;
            if (editMode == IFluidContainerManager.ContainerEditMode.FILL) {
                this.drainTank(outputSlot);
            } else if (editMode == IFluidContainerManager.ContainerEditMode.EMPTY) {
                this.fillTank(outputSlot);
            } else if (editMode == IFluidContainerManager.ContainerEditMode.BOTH && (fluidHandlerItem = FluidInventorySlot.tryGetFluidHandlerUnstacked(stack = this.getStack())) != null) {
                boolean hasEmpty = false;
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (this.isDraining() || this.getFluidTank().insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    this.fillTank(outputSlot);
                    return;
                }
                if (this.isFilling()) {
                    if (this.moveItem(outputSlot, stack)) {
                        this.setFilling(false);
                    }
                } else if (this.getFluidTank().isEmpty() && hasEmpty || this.isDraining() || fluidHandlerItem.fill(this.getFluidTank().getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.drainTank(outputSlot);
                }
            }
        }
    }

    default public void fillTank(IInventorySlot outputSlot) {
        block2: {
            int itemTanks;
            IFluidHandlerItem itemFluidHandler;
            block3: {
                itemFluidHandler = Capabilities.FLUID.getCapability(this.getStack());
                if (itemFluidHandler == null) break block2;
                itemTanks = itemFluidHandler.getTanks();
                if (itemTanks != 1) break block3;
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (fluidInItem.isEmpty() || !this.getFluidTank().isFluidValid(fluidInItem)) break block2;
                this.drainItemAndMove(outputSlot, fluidInItem);
                break block2;
            }
            if (itemTanks > 1) {
                FluidStack knownFluid;
                Set<FluidStack> knownFluids = this.gatherKnownFluids(itemFluidHandler, itemTanks);
                Iterator<FluidStack> iterator = knownFluids.iterator();
                while (!(!iterator.hasNext() || this.drainItemAndMove(outputSlot, knownFluid = iterator.next()) && this.isEmpty())) {
                }
            }
        }
    }

    default public void drainTank(IInventorySlot outputSlot) {
        FluidStack fluidInTank;
        if (Capabilities.FLUID.hasCapability(this.getStack()) && !(fluidInTank = this.getFluidTank().getFluid()).isEmpty()) {
            FluidStack simulatedDrain = this.getFluidTank().extract(fluidInTank.getAmount(), Action.SIMULATE, AutomationType.INTERNAL);
            if (simulatedDrain.isEmpty()) {
                return;
            }
            ItemStack inputCopy = this.getStack().copyWithCount(1);
            IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(inputCopy);
            if (fluidHandlerItem != null) {
                IFluidHandlerItem containerCap;
                int toDrain = fluidHandlerItem.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
                if (this.getCount() == 1 && (containerCap = Capabilities.FLUID.getCapability(fluidHandlerItem.getContainer())) != null && containerCap.fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.setStack(fluidHandlerItem.getContainer());
                    this.setDraining(true);
                    MekanismUtils.logMismatchedStackSize(this.getFluidTank().shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    return;
                }
                if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
                    MekanismUtils.logMismatchedStackSize(this.getFluidTank().shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    this.setDraining(false);
                }
            }
        }
    }

    private boolean drainItemAndMove(IInventorySlot outputSlot, FluidStack fluidToTransfer) {
        IFluidHandlerItem containerCap;
        int toTransfer;
        FluidStack simulatedRemainder = this.getFluidTank().insert(fluidToTransfer, Action.SIMULATE, AutomationType.INTERNAL);
        int remainder = simulatedRemainder.getAmount();
        if (remainder == (toTransfer = fluidToTransfer.getAmount())) {
            return false;
        }
        ItemStack stack = this.getStack();
        if (Capabilities.FLUID.getCapability(stack) == null) {
            return false;
        }
        ItemStack input = stack.copyWithCount(1);
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(input);
        if (fluidHandlerItem == null) {
            return false;
        }
        FluidStack drained = fluidHandlerItem.drain(fluidToTransfer.copyWithAmount(toTransfer - remainder), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return false;
        }
        if (this.getCount() == 1 && (containerCap = Capabilities.FLUID.getCapability(fluidHandlerItem.getContainer())) != null && !containerCap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            this.setStack(fluidHandlerItem.getContainer());
            this.getFluidTank().insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            this.setFilling(true);
            return true;
        }
        if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
            this.getFluidTank().insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    private boolean moveItem(IInventorySlot outputSlot, ItemStack stackToMove) {
        if (outputSlot.isEmpty()) {
            outputSlot.setStack(stackToMove);
        } else {
            ItemStack outputStack = outputSlot.getStack();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)stackToMove) || outputStack.getCount() >= outputSlot.getLimit(outputStack)) {
                return false;
            }
            MekanismUtils.logMismatchedStackSize(outputSlot.growStack(1, Action.EXECUTE), 1L);
        }
        MekanismUtils.logMismatchedStackSize(this.shrinkStack(1, Action.EXECUTE), 1L);
        return true;
    }

    default public boolean fillTank() {
        IFluidHandlerItem itemFluidHandler;
        if (this.getCount() == 1 && (itemFluidHandler = Capabilities.FLUID.getCapability(this.getStack())) != null) {
            Set<FluidStack> knownFluids;
            int tanks = itemFluidHandler.getTanks();
            if (tanks == 1) {
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (!fluidInItem.isEmpty() && this.getFluidTank().isFluidValid(fluidInItem) && this.fillHandlerFromOther(this.getFluidTank(), (IFluidHandler)itemFluidHandler, fluidInItem)) {
                    this.setStack(itemFluidHandler.getContainer());
                    return true;
                }
            } else if (tanks > 1 && !(knownFluids = this.gatherKnownFluids(itemFluidHandler, tanks)).isEmpty()) {
                boolean changed = false;
                for (FluidStack knownFluid : knownFluids) {
                    if (!this.fillHandlerFromOther(this.getFluidTank(), (IFluidHandler)itemFluidHandler, knownFluid)) continue;
                    changed = true;
                }
                if (changed) {
                    this.setStack(itemFluidHandler.getContainer());
                    return true;
                }
            }
        }
        return false;
    }

    private Set<FluidStack> gatherKnownFluids(IFluidHandlerItem itemFluidHandler, int tanks) {
        HashMap<FluidStack, FluidStack> knownFluids = new HashMap<FluidStack, FluidStack>();
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack fluidInItem = itemFluidHandler.getFluidInTank(tank);
            if (fluidInItem.isEmpty()) continue;
            FluidStack knownFluid = (FluidStack)knownFluids.get(fluidInItem);
            if (knownFluid == null) {
                if (itemFluidHandler.drain(fluidInItem, IFluidHandler.FluidAction.SIMULATE).isEmpty() || !this.getFluidTank().isFluidValid(fluidInItem)) continue;
                FluidStack copy = fluidInItem.copy();
                knownFluids.put(copy, copy);
                continue;
            }
            knownFluid.grow(fluidInItem.getAmount());
        }
        return knownFluids.keySet();
    }

    private boolean fillHandlerFromOther(IExtendedFluidTank handlerToFill, IFluidHandler handlerToDrain, FluidStack fluid) {
        int drained;
        FluidStack simulatedRemainder;
        int remainder;
        FluidStack simulatedDrain = handlerToDrain.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
        if (!simulatedDrain.isEmpty() && (remainder = (simulatedRemainder = this.getFluidTank().insert(simulatedDrain, Action.SIMULATE, AutomationType.INTERNAL)).getAmount()) < (drained = simulatedDrain.getAmount())) {
            handlerToFill.insert(handlerToDrain.drain(fluid.copyWithAmount(drained - remainder), IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }
}

