/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.attachments.containers.AttachedContainers;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FuelInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.inventory.slot.chemical.InfusionInventorySlot;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlotsBuilder {
    @Nullable
    private static final IContentsListener LISTENER = null;
    private static final int X = 0;
    private static final int Y = 0;
    private final List<IInventorySlot> slots = new ArrayList<IInventorySlot>();
    private final ItemStack backingStack;

    public static ItemSlotsBuilder builder(ItemStack backingStack) {
        return new ItemSlotsBuilder(backingStack);
    }

    private ItemSlotsBuilder(ItemStack backingStack) {
        this.backingStack = backingStack;
    }

    public List<IInventorySlot> build() {
        return List.copyOf(this.slots);
    }

    public ItemSlotsBuilder addBasicFactorySlots(int process, Predicate<ItemStack> recipeInputPredicate) {
        return this.addBasicFactorySlots(process, recipeInputPredicate, false);
    }

    public ItemSlotsBuilder addBasicFactorySlots(int process, Predicate<ItemStack> recipeInputPredicate, boolean secondaryOutput) {
        for (int i = 0; i < process; ++i) {
            this.addInput(recipeInputPredicate).addOutput();
            if (!secondaryOutput) continue;
            this.addOutput();
        }
        return this;
    }

    public ItemSlotsBuilder addSlots(int count, SlotCreator creator) {
        for (int i = 0; i < count; ++i) {
            this.addSlot(creator);
        }
        return this;
    }

    public ItemSlotsBuilder addSlot(SlotCreator creator) {
        return this.addSlot(creator.create(LISTENER, 0, 0));
    }

    public ItemSlotsBuilder addSlot(IInventorySlot slot) {
        this.slots.add(slot);
        return this;
    }

    public ItemSlotsBuilder addFuelSlot() {
        return this.addFuelSlot(stack -> stack.getBurnTime(null));
    }

    public ItemSlotsBuilder addFuelSlot(ToIntFunction<@NotNull ItemStack> fuelValue) {
        return this.addSlot(FuelInventorySlot.forFuel(fuelValue, LISTENER, 0, 0));
    }

    public ItemSlotsBuilder addOutput() {
        return this.addSlot(OutputInventorySlot.at(LISTENER, 0, 0));
    }

    public ItemSlotsBuilder addInput(Predicate<@NotNull ItemStack> isItemValid) {
        return this.addSlot(InputInventorySlot.at(isItemValid, LISTENER, 0, 0));
    }

    public <RECIPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> ItemSlotsBuilder addInput(IMekanismRecipeTypeProvider<RECIPE, INPUT_CACHE> recipeType, ContainsRecipe<INPUT_CACHE> containsRecipe) {
        return this.addInput(stack -> containsRecipe.check(recipeType.getInputCache(), null, (ItemStack)stack));
    }

    public ItemSlotsBuilder addEnergy() {
        return this.addEnergy(0);
    }

    public ItemSlotsBuilder addEnergy(int containerIndex) {
        return this.addEnergySlot(containerIndex, (container, listener, x, y) -> EnergyInventorySlot.fillOrConvert(container, () -> null, listener, x, y));
    }

    public ItemSlotsBuilder addEnergySlot(int containerIndex, ContainerBasedSlotCreator<IEnergyContainer> slotCreator) {
        return this.addContainerInput(ContainerType.ENERGY, containerIndex, slotCreator);
    }

    public ItemSlotsBuilder addFluidSlot(int tankIndex, ContainerBasedSlotCreator<IExtendedFluidTank> slotCreator) {
        return this.addContainerInput(ContainerType.FLUID, tankIndex, slotCreator);
    }

    public ItemSlotsBuilder addGasSlot(int tankIndex, ContainerBasedSlotCreator<IGasTank> slotCreator) {
        return this.addContainerInput(ContainerType.GAS, tankIndex, slotCreator);
    }

    public ItemSlotsBuilder addGasSlotWithConversion(int tankIndex) {
        return this.addGasSlot(tankIndex, (tank, listener, x, y) -> GasInventorySlot.fillOrConvert(tank, () -> null, listener, x, y));
    }

    public ItemSlotsBuilder addInfusionSlot(int tankIndex, ContainerBasedSlotCreator<IInfusionTank> slotCreator) {
        return this.addContainerInput(ContainerType.INFUSION, tankIndex, slotCreator);
    }

    public ItemSlotsBuilder addInfusionSlotWithConversion(int tankIndex) {
        return this.addInfusionSlot(tankIndex, (tank, listener, x, y) -> InfusionInventorySlot.fillOrConvert(tank, () -> null, listener, x, y));
    }

    public ItemSlotsBuilder addPigmentSlot(int tankIndex, ContainerBasedSlotCreator<IPigmentTank> slotCreator) {
        return this.addContainerInput(ContainerType.PIGMENT, tankIndex, slotCreator);
    }

    public ItemSlotsBuilder addSlurrySlot(int tankIndex, ContainerBasedSlotCreator<ISlurryTank> slotCreator) {
        return this.addContainerInput(ContainerType.SLURRY, tankIndex, slotCreator);
    }

    private <CONTAINER extends INBTSerializable<CompoundTag>> ItemSlotsBuilder addContainerInput(ContainerType<CONTAINER, ? extends AttachedContainers<CONTAINER>, ?> containerType, int containerIndex, ContainerBasedSlotCreator<CONTAINER> slotCreator) {
        AttachedContainers<CONTAINER> attachment = containerType.getAttachment((IAttachmentHolder)this.backingStack);
        if (attachment == null) {
            throw new IllegalStateException("Expected stack to have attached " + containerType.getAttachmentName() + " containers.");
        }
        List<CONTAINER> containers = attachment.getContainers();
        if (containerIndex >= containers.size()) {
            throw new IllegalStateException("Expected stack to have an attached " + containerType.getAttachmentName() + " container with index " + containerIndex);
        }
        return this.addContainerSlot((INBTSerializable)containers.get(containerIndex), slotCreator);
    }

    public <CONTAINER> ItemSlotsBuilder addContainerSlot(CONTAINER container, ContainerBasedSlotCreator<CONTAINER> slotCreator) {
        return this.addSlot(slotCreator.create(container, LISTENER, 0, 0));
    }

    @FunctionalInterface
    public static interface SlotCreator {
        public IInventorySlot create(@Nullable IContentsListener var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface ContainsRecipe<INPUT_CACHE extends IInputRecipeCache> {
        public boolean check(INPUT_CACHE var1, @Nullable Level var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface ContainerBasedSlotCreator<CONTAINER> {
        public IInventorySlot create(CONTAINER var1, @Nullable IContentsListener var2, int var3, int var4);
    }
}

