/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedChemicalInventorySlot<MERGED extends MergedChemicalTank>
extends BasicInventorySlot {
    protected final MERGED mergedTank;

    public static MergedChemicalInventorySlot<MergedChemicalTank> drain(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NotNull ItemStack> gasInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getGasTank(), Capabilities.GAS);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getInfusionTank(), Capabilities.INFUSION);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getPigmentTank(), Capabilities.PIGMENT);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = ChemicalInventorySlot.getDrainInsertPredicate(chemicalTank.getSlurryTank(), Capabilities.SLURRY);
        BiPredicate<@NotNull ItemStack, @NotNull AutomationType> insertPredicate = (stack, automationType) -> switch (chemicalTank.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedChemicalTank.Current.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.EMPTY -> gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        };
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> automationType == AutomationType.MANUAL || !insertPredicate.test((ItemStack)stack, (AutomationType)((Object)automationType)), insertPredicate, listener, x, y);
    }

    public static MergedChemicalInventorySlot<MergedChemicalTank> fill(MergedChemicalTank chemicalTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(chemicalTank, "Merged chemical tank cannot be null");
        Predicate<@NotNull ItemStack> gasExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getGasTank(), Capabilities.GAS);
        Predicate<@NotNull ItemStack> infusionExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getInfusionTank(), Capabilities.INFUSION);
        Predicate<@NotNull ItemStack> pigmentExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getPigmentTank(), Capabilities.PIGMENT);
        Predicate<@NotNull ItemStack> slurryExtractPredicate = ChemicalInventorySlot.getFillExtractPredicate(chemicalTank.getSlurryTank(), Capabilities.SLURRY);
        Predicate<@NotNull ItemStack> gasInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getGasTank(), Capabilities.GAS, stack);
        Predicate<@NotNull ItemStack> infusionInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getInfusionTank(), Capabilities.INFUSION, stack);
        Predicate<@NotNull ItemStack> pigmentInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getPigmentTank(), Capabilities.PIGMENT, stack);
        Predicate<@NotNull ItemStack> slurryInsertPredicate = stack -> ChemicalInventorySlot.fillInsertCheck(chemicalTank.getSlurryTank(), Capabilities.SLURRY, stack);
        return new MergedChemicalInventorySlot<MergedChemicalTank>(chemicalTank, (stack, automationType) -> {
            if (automationType == AutomationType.MANUAL) {
                return true;
            }
            return switch (chemicalTank.getCurrent()) {
                default -> throw new IncompatibleClassChangeError();
                case MergedChemicalTank.Current.GAS -> gasExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.INFUSION -> infusionExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.PIGMENT -> pigmentExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.SLURRY -> slurryExtractPredicate.test((ItemStack)stack);
                case MergedChemicalTank.Current.EMPTY -> gasExtractPredicate.test((ItemStack)stack) && infusionExtractPredicate.test((ItemStack)stack) && pigmentExtractPredicate.test((ItemStack)stack) && slurryExtractPredicate.test((ItemStack)stack);
            };
        }, (stack, automationType) -> switch (chemicalTank.getCurrent()) {
            default -> throw new IncompatibleClassChangeError();
            case MergedChemicalTank.Current.GAS -> gasInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.INFUSION -> infusionInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.PIGMENT -> pigmentInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.SLURRY -> slurryInsertPredicate.test((ItemStack)stack);
            case MergedChemicalTank.Current.EMPTY -> gasInsertPredicate.test((ItemStack)stack) || infusionInsertPredicate.test((ItemStack)stack) || pigmentInsertPredicate.test((ItemStack)stack) || slurryInsertPredicate.test((ItemStack)stack);
        }, listener, x, y);
    }

    protected MergedChemicalInventorySlot(MERGED mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(mergedTank, canExtract, canInsert, (Predicate<ItemStack>)alwaysTrue, listener, x, y);
    }

    protected MergedChemicalInventorySlot(MERGED mergedTank, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.mergedTank = mergedTank;
    }

    public void drainChemicalTanks() {
        this.drainChemicalTank(MergedTank.CurrentType.GAS);
        this.drainChemicalTank(MergedTank.CurrentType.INFUSION);
        this.drainChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.drainChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void drainChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), (IChemicalHandler)Capabilities.GAS.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), (IChemicalHandler)Capabilities.INFUSION.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), (IChemicalHandler)Capabilities.PIGMENT.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.drainChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), (IChemicalHandler)Capabilities.SLURRY.getCapability(this.current));
        }
    }

    public void fillChemicalTanks() {
        this.fillChemicalTank(MergedTank.CurrentType.GAS);
        this.fillChemicalTank(MergedTank.CurrentType.INFUSION);
        this.fillChemicalTank(MergedTank.CurrentType.PIGMENT);
        this.fillChemicalTank(MergedTank.CurrentType.SLURRY);
    }

    public void fillChemicalTank(MergedTank.CurrentType type) {
        if (type == MergedTank.CurrentType.GAS) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getGasTank(), (IChemicalHandler)Capabilities.GAS.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.INFUSION) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getInfusionTank(), (IChemicalHandler)Capabilities.INFUSION.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.PIGMENT) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getPigmentTank(), (IChemicalHandler)Capabilities.PIGMENT.getCapability(this.current));
        } else if (type == MergedTank.CurrentType.SLURRY) {
            ChemicalInventorySlot.fillChemicalTank(this, ((MergedChemicalTank)this.mergedTank).getSlurryTank(), (IChemicalHandler)Capabilities.SLURRY.getCapability(this.current));
        }
    }
}

