/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.MultiTypeCapability;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PigmentInventorySlot
extends ChemicalInventorySlot<Pigment, PigmentStack> {
    public static PigmentInventorySlot fill(IPigmentTank pigmentTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        return new PigmentInventorySlot(pigmentTank, PigmentInventorySlot.getFillExtractPredicate(pigmentTank, Capabilities.PIGMENT), stack -> PigmentInventorySlot.fillInsertCheck(pigmentTank, Capabilities.PIGMENT, stack), listener, x, y);
    }

    public static PigmentInventorySlot drain(IPigmentTank pigmentTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(pigmentTank, "Pigment tank cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = PigmentInventorySlot.getDrainInsertPredicate(pigmentTank, Capabilities.PIGMENT);
        return new PigmentInventorySlot(pigmentTank, insertPredicate.negate(), insertPredicate, listener, x, y);
    }

    private PigmentInventorySlot(IPigmentTank pigmentTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(pigmentTank, () -> null, canExtract, canInsert, listener, x, y);
    }

    private PigmentInventorySlot(IPigmentTank pigmentTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(pigmentTank, worldSupplier, canExtract, canInsert, listener, x, y);
    }

    @Override
    protected MultiTypeCapability<IPigmentHandler> getChemicalCapability() {
        return Capabilities.PIGMENT;
    }
}

