/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Set;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IModuleItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemModule
extends Item
implements IModuleItem {
    private final IModuleDataProvider<?> moduleData;

    public ItemModule(IModuleDataProvider<?> moduleData, Item.Properties properties) {
        super(properties);
        this.moduleData = moduleData;
    }

    @Override
    public ModuleData<?> getModuleData() {
        return this.moduleData.getModuleData();
    }

    @NotNull
    public Rarity getRarity(@NotNull ItemStack stack) {
        return this.getModuleData().getRarity();
    }

    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            tooltip.add((Component)MekanismLang.MODULE_SUPPORTED.translateColored(EnumColor.BRIGHT_GREEN));
            for (Item item : IModuleHelper.INSTANCE.getSupported(this.getModuleData())) {
                tooltip.add((Component)MekanismLang.GENERIC_LIST.translate(item.getName(new ItemStack((ItemLike)item))));
            }
            Set<ModuleData<?>> conflicting = IModuleHelper.INSTANCE.getConflicting(this.getModuleData());
            if (!conflicting.isEmpty()) {
                tooltip.add((Component)MekanismLang.MODULE_CONFLICTING.translateColored(EnumColor.RED));
                for (ModuleData<?> module : conflicting) {
                    tooltip.add((Component)MekanismLang.GENERIC_LIST.translate(module));
                }
            }
        } else {
            ModuleData<?> moduleData = this.getModuleData();
            tooltip.add((Component)TextComponentUtil.translate(moduleData.getDescriptionTranslationKey()));
            tooltip.add((Component)MekanismLang.MODULE_STACKABLE.translateColored(EnumColor.GRAY, EnumColor.AQUA, moduleData.getMaxStackSize()));
            tooltip.add((Component)MekanismLang.HOLD_FOR_SUPPORTED_ITEMS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
        }
    }

    @NotNull
    public String getDescriptionId() {
        return this.getModuleData().getTranslationKey();
    }
}

