/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.function.Supplier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;

public class ItemNutritionalPasteBucket
extends BucketItem
implements ICapabilityAware {
    public ItemNutritionalPasteBucket(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        int needed;
        if (MekanismUtils.isPlayingMode(player) && (needed = Math.min(20 - player.getFoodData().getFoodLevel(), 1000 / MekanismConfig.general.nutritionalPasteMBPerFood.get())) > 0) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return super.use(level, player, hand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        int needed;
        Player player;
        if (entity instanceof Player && MekanismUtils.isPlayingMode(player = (Player)entity) && (needed = Math.min(20 - player.getFoodData().getFoodLevel(), 1000 / MekanismConfig.general.nutritionalPasteMBPerFood.get())) > 0) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
                serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (!level.isClientSide) {
                player.getFoodData().eat(needed, MekanismConfig.general.nutritionalPasteSaturation.get());
            }
            stack.shrink(1);
            return stack.isEmpty() ? new ItemStack((ItemLike)Items.BUCKET) : stack;
        }
        return super.finishUsingItem(stack, level, entity);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FLUID.item(), (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{this});
    }
}

