/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.DriveMetadata;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tier.QIODriveTier;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemQIODrive
extends Item
implements IQIODriveItem {
    private final QIODriveTier tier;

    public ItemQIODrive(QIODriveTier tier, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.tier = tier;
    }

    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        DriveMetadata meta = (DriveMetadata)stack.getData(MekanismAttachmentTypes.DRIVE_METADATA);
        tooltip.add((Component)MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(meta.count()), TextUtils.format(this.getCountCapacity(stack))));
        tooltip.add((Component)MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(meta.types()), TextUtils.format(this.getTypeCapacity(stack))));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return TextComponentUtil.build(this.tier.getBaseTier().getColor(), super.getName(stack));
    }

    @Override
    public long getCountCapacity(ItemStack stack) {
        return this.tier.getMaxCount();
    }

    @Override
    public int getTypeCapacity(ItemStack stack) {
        return this.tier.getMaxTypes();
    }
}

