/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasDescription;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.NoClampRateLimitEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.common.util.text.UpgradeDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockTooltip<BLOCK extends Block>
extends ItemBlockMekanism<BLOCK>
implements ICapabilityAware,
IAttachmentAware {
    private final boolean hasDetails;

    public ItemBlockTooltip(BLOCK block, Item.Properties properties) {
        this(block, false, properties);
    }

    public ItemBlockTooltip(BLOCK block) {
        this(block, true, new Item.Properties());
    }

    protected ItemBlockTooltip(BLOCK block, boolean hasDetails, Item.Properties properties) {
        super(block, properties);
        this.hasDetails = hasDetails;
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        InventoryUtils.dropItemContents(item, damageSource);
    }

    public boolean placeBlock(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        AttributeHasBounding hasBounding = Attribute.get(state, AttributeHasBounding.class);
        if (hasBounding == null) {
            return super.placeBlock(context, state);
        }
        return hasBounding.handle(context.getLevel(), context.getClickedPos(), state, context, (level, pos, ctx) -> WorldUtils.isValidReplaceableBlock((BlockGetter)level, ctx, pos)) && super.placeBlock(context, state);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.descriptionKey)) {
            tooltip.add((Component)((IHasDescription)this.getBlock()).getDescription().translate());
        } else if (this.hasDetails && MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addDetails(stack, world, tooltip, flag);
        } else {
            this.addStats(stack, world, tooltip, flag);
            if (this.hasDetails) {
                tooltip.add((Component)MekanismLang.HOLD_FOR_DETAILS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_DESCRIPTION.translateColored(EnumColor.GRAY, EnumColor.AQUA, MekanismKeyHandler.descriptionKey.getTranslatedKeyMessage()));
        }
    }

    protected void addStats(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
    }

    protected void addDetails(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        IItemSecurityUtils.INSTANCE.addSecurityTooltip(stack, tooltip);
        this.addTypeDetails(stack, world, tooltip, flag);
        FluidStack fluidStack = StorageUtils.getStoredFluidFromAttachment(stack);
        if (!fluidStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, TextUtils.format(fluidStack.getAmount())));
        }
        if (Attribute.has(this.getBlock(), Attributes.AttributeInventory.class) && ContainerType.ITEM.supports(stack)) {
            tooltip.add((Component)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.hasInventory(stack)));
        }
        if (Attribute.has(this.getBlock(), AttributeUpgradeSupport.class)) {
            for (Map.Entry<Upgrade, Integer> entry : ((UpgradeAware)stack.getData(MekanismAttachmentTypes.UPGRADES)).getUpgrades().entrySet()) {
                tooltip.add(UpgradeDisplay.of(entry.getKey(), entry.getValue()).getTextComponent());
            }
        }
    }

    protected void addTypeDetails(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (this.exposesEnergyCap()) {
            StorageUtils.addStoredEnergy(stack, tooltip, false);
        }
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        if (this.exposesEnergyCap()) {
            return slotChanged || oldStack.getItem() != newStack.getItem();
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        if (this.exposesEnergyCap()) {
            return oldStack.getItem() != newStack.getItem();
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    protected Predicate<@NotNull AutomationType> getEnergyCapInsertPredicate() {
        return BasicEnergyContainer.alwaysTrue;
    }

    protected boolean exposesEnergyCap() {
        return Attribute.has(this.getBlock(), AttributeEnergy.class);
    }

    @Nullable
    protected IEnergyContainer getDefaultEnergyContainer(ItemStack stack) {
        Object block = this.getBlock();
        AttributeEnergy attributeEnergy = Attribute.get(block, AttributeEnergy.class);
        if (attributeEnergy == null) {
            throw new IllegalStateException("Expected block " + RegistryUtils.getName(block) + " to have the energy attribute");
        }
        FloatingLongSupplier maxEnergy = attributeEnergy::getStorage;
        if (Attribute.matches(block, AttributeUpgradeSupport.class, attribute -> attribute.supportedUpgrades().contains(Upgrade.ENERGY))) {
            maxEnergy = new UpgradeBasedFloatingLongCache(stack, maxEnergy);
            return NoClampRateLimitEnergyContainer.create(maxEnergy, BasicEnergyContainer.manualOnly, this.getEnergyCapInsertPredicate());
        }
        return RateLimitEnergyContainer.create(maxEnergy, BasicEnergyContainer.manualOnly, this.getEnergyCapInsertPredicate());
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        if (Attribute.has(this.getBlock(), Attributes.AttributeSecurity.class)) {
            event.registerItem(IItemSecurityUtils.INSTANCE.ownerCapability(), (stack, ctx) -> (IOwnerObject)stack.getData(MekanismAttachmentTypes.SECURITY), new ItemLike[]{this});
            event.registerItem(IItemSecurityUtils.INSTANCE.securityCapability(), (stack, ctx) -> (ISecurityObject)stack.getData(MekanismAttachmentTypes.SECURITY), new ItemLike[]{this});
        }
    }

    @Override
    public void attachAttachments(IEventBus eventBus) {
        if (Attribute.has(this.getBlock(), AttributeEnergy.class)) {
            IEventBus energyEventBus = this.exposesEnergyCap() ? eventBus : null;
            ContainerType.ENERGY.addDefaultContainer(energyEventBus, (Item)this, this::getDefaultEnergyContainer, MekanismConfig.storage, MekanismConfig.usage);
        }
    }

    private static class UpgradeBasedFloatingLongCache
    implements FloatingLongSupplier {
        private final FloatingLongSupplier baseStorage;
        private final UpgradeAware upgradeAware;
        private int lastInstalled;
        private FloatingLong value;

        private UpgradeBasedFloatingLongCache(ItemStack stack, FloatingLongSupplier baseStorage) {
            this.upgradeAware = (UpgradeAware)stack.getData(MekanismAttachmentTypes.UPGRADES);
            this.lastInstalled = this.upgradeAware.getUpgradeCount(Upgrade.ENERGY);
            this.baseStorage = baseStorage;
            this.value = MekanismUtils.getMaxEnergy(this.lastInstalled, this.baseStorage.get());
        }

        @Override
        @NotNull
        public FloatingLong get() {
            int installed = this.upgradeAware.getUpgradeCount(Upgrade.ENERGY);
            if (installed != this.lastInstalled) {
                this.lastInstalled = installed;
                this.value = MekanismUtils.getMaxEnergy(this.lastInstalled, this.baseStorage.get());
            }
            return this.value;
        }
    }
}

