/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.security.ItemSecurityUtils;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidBlock;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockFluidTank
extends ItemBlockTooltip<BlockTile<?, ?>>
implements IModeItem.IAttachmentBasedModeItem<Boolean> {
    public ItemBlockFluidTank(BlockFluidTank block) {
        super(block);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.fluidTank());
    }

    @Override
    @NotNull
    public FluidTankTier getTier() {
        return Attribute.getTier(this.getBlock(), FluidTankTier.class);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        FluidTankTier tier = this.getTier();
        FluidStack fluidStack = StorageUtils.getStoredFluidFromAttachment(stack);
        if (fluidStack.isEmpty()) {
            tooltip.add((Component)MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED));
        } else if (tier == FluidTankTier.CREATIVE) {
            tooltip.add((Component)MekanismLang.GENERIC_STORED.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, MekanismLang.INFINITE));
        } else {
            tooltip.add((Component)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, TextUtils.format(fluidStack.getAmount())));
        }
        if (tier == FluidTankTier.CREATIVE) {
            tooltip.add((Component)MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, EnumColor.GRAY, MekanismLang.INFINITE));
        } else {
            tooltip.add((Component)MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, EnumColor.GRAY, TextUtils.format(tier.getStorage())));
        }
    }

    @Override
    protected void addTypeDetails(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)MekanismLang.BUCKET_MODE.translateColored(EnumColor.INDIGO, BooleanStateDisplay.YesNo.of((Boolean)this.getMode(stack), true)));
        super.addTypeDetails(stack, world, tooltip, flag);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (((Boolean)this.getMode(stack)).booleanValue() && !entity.isBaby()) {
            Level level = player.level();
            if (ItemSecurityUtils.get().tryClaimItem(level, player, stack)) {
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!IItemSecurityUtils.INSTANCE.canAccessOrDisplayError(player, stack)) {
                return InteractionResult.FAIL;
            }
            if (stack.getCount() > 1) {
                return InteractionResult.PASS;
            }
            if (entity instanceof Cow || entity instanceof Goat) {
                IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return InteractionResult.PASS;
                }
                FluidStack milk = new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
                if (fluidTank.insert(milk, Action.EXECUTE, AutomationType.MANUAL).getAmount() < 1000) {
                    player.playSound(entity instanceof Cow ? SoundEvents.COW_MILK : SoundEvents.GOAT_MILK, 1.0f, 1.0f);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        return context.getPlayer() == null || (Boolean)this.getMode(context.getItemInHand()) != false ? InteractionResult.PASS : super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (((Boolean)this.getMode(stack)).booleanValue()) {
            if (ItemSecurityUtils.get().tryClaimItem(world, player, stack)) {
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
            }
            if (!IItemSecurityUtils.INSTANCE.canAccessOrDisplayError(player, stack)) {
                return InteractionResultHolder.fail((Object)stack);
            }
            if (stack.getCount() > 1) {
                return InteractionResultHolder.pass((Object)stack);
            }
            BlockHitResult result = ItemBlockFluidTank.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)(player.isShiftKeyDown() ? ClipContext.Fluid.NONE : ClipContext.Fluid.SOURCE_ONLY));
            if (result.getType() == HitResult.Type.BLOCK) {
                BlockPos pos = result.getBlockPos();
                if (!world.mayInteract(player, pos)) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                if (!player.isShiftKeyDown()) {
                    if (!player.mayUseItemAt(pos, result.getDirection(), stack)) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    BlockState blockState = world.getBlockState(pos);
                    FluidState fluidState = blockState.getFluidState();
                    Optional sound = Optional.empty();
                    if (!fluidState.isEmpty() && fluidState.isSource()) {
                        Fluid fluid = fluidState.getType();
                        FluidStack fluidStack = new FluidStack(fluid, 1000);
                        Block block = blockState.getBlock();
                        if (block instanceof IFluidBlock) {
                            IFluidBlock fluidBlock = (IFluidBlock)block;
                            fluidStack = fluidBlock.drain(world, pos, IFluidHandler.FluidAction.SIMULATE);
                            if (!ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                return InteractionResultHolder.pass((Object)stack);
                            }
                            fluidStack = fluidBlock.drain(world, pos, IFluidHandler.FluidAction.EXECUTE);
                        } else if (block instanceof BucketPickup) {
                            BucketPickup bucketPickup = (BucketPickup)block;
                            if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                                BucketItem bucket;
                                ItemStack pickedUpStack = bucketPickup.pickupBlock(player, (LevelAccessor)world, pos, blockState);
                                if (pickedUpStack.isEmpty()) {
                                    return InteractionResultHolder.pass((Object)stack);
                                }
                                Item item = pickedUpStack.getItem();
                                if (item instanceof BucketItem && !ItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = (bucket = (BucketItem)item).getFluid(), 1000))) {
                                    Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{RegistryUtils.getName(fluidState.getType()), pos, world.dimension().location(), RegistryUtils.getName(fluid)});
                                    return InteractionResultHolder.fail((Object)stack);
                                }
                                sound = bucketPickup.getPickupSound(blockState);
                            }
                        }
                        if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            this.uncheckedGrow(fluidTank, fluidStack);
                            WorldUtils.playFillSound(player, (LevelAccessor)world, pos, fluidStack, sound.orElse(null));
                            world.gameEvent((Entity)player, GameEvent.FLUID_PICKUP, pos);
                            return InteractionResultHolder.success((Object)stack);
                        }
                        return InteractionResultHolder.fail((Object)stack);
                    }
                } else {
                    if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() < 1000 || !player.mayUseItemAt(pos.relative(result.getDirection()), result.getDirection(), stack)) {
                        return InteractionResultHolder.fail((Object)stack);
                    }
                    if (WorldUtils.tryPlaceContainedLiquid(player, world, pos, fluidTank.getFluid(), result.getDirection())) {
                        if (!player.isCreative()) {
                            MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                        }
                        world.gameEvent((Entity)player, GameEvent.FLUID_PLACE, pos);
                        return InteractionResultHolder.success((Object)stack);
                    }
                }
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private void uncheckedGrow(IExtendedFluidTank fluidTank, FluidStack fluidStack) {
        if (this.getTier() != FluidTankTier.CREATIVE) {
            if (fluidTank.isEmpty()) {
                fluidTank.setStack(fluidStack);
            } else {
                MekanismUtils.logMismatchedStackSize(fluidTank.growStack(fluidStack.getAmount(), Action.EXECUTE), fluidStack.getAmount());
            }
        }
    }

    private static boolean validFluid(@NotNull IExtendedFluidTank fluidTank, @NotNull FluidStack fluidStack) {
        return !fluidStack.isEmpty() && fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL).isEmpty();
    }

    private static IExtendedFluidTank getExtendedFluidTank(@NotNull ItemStack stack) {
        IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability(stack);
        if (fluidHandlerItem instanceof IMekanismFluidHandler) {
            IMekanismFluidHandler fluidHandler = (IMekanismFluidHandler)fluidHandlerItem;
            return fluidHandler.getFluidTank(0, null);
        }
        return null;
    }

    @Override
    public AttachmentType<Boolean> getModeAttachment() {
        return (AttachmentType)MekanismAttachmentTypes.BUCKET_MODE.get();
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = (Boolean)this.getMode(stack) == false;
            this.setMode(stack, player, newState);
            displayChange.sendMessage(player, newState, s -> MekanismLang.BUCKET_MODE.translate(BooleanStateDisplay.OnOff.of(s, true)));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return MekanismLang.BUCKET_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack), true));
    }

    public static class BasicDrainCauldronInteraction
    extends BasicCauldronInteraction {
        public static final BasicDrainCauldronInteraction WATER = new BasicDrainCauldronInteraction((Fluid)Fluids.WATER){

            @Override
            @NotNull
            protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
                if ((Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL) == 3) {
                    return super.interact(state, level, pos, player, hand, stack, fluidTank);
                }
                return InteractionResult.PASS;
            }
        };
        public static final BasicDrainCauldronInteraction LAVA = new BasicDrainCauldronInteraction((Fluid)Fluids.LAVA);
        private final Fluid type;

        private BasicDrainCauldronInteraction(Fluid type) {
            this.type = type;
        }

        @Override
        @NotNull
        protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
            FluidStack fluidStack = new FluidStack(this.type, 1000);
            FluidStack remainder = fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL);
            if (remainder.isEmpty()) {
                if (!level.isClientSide) {
                    if (!player.isCreative()) {
                        ((ItemBlockFluidTank)stack.getItem()).uncheckedGrow(fluidTank, fluidStack);
                    }
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                    SoundEvent fillSound = fluidStack.getFluidType().getSound(null, (BlockGetter)level, pos, SoundActions.BUCKET_FILL);
                    if (fillSound != null) {
                        level.playSound(null, pos, fillSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    level.gameEvent(null, GameEvent.FLUID_PICKUP, pos);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
    }

    public static abstract class BasicCauldronInteraction
    implements CauldronInteraction {
        public static final BasicCauldronInteraction EMPTY = new BasicCauldronInteraction(){

            @Nullable
            private BlockState getState(FluidStack current) {
                if (current.is((Fluid)Fluids.WATER)) {
                    return (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
                }
                if (current.is((Fluid)Fluids.LAVA)) {
                    return Blocks.LAVA_CAULDRON.defaultBlockState();
                }
                return null;
            }

            @Override
            @NotNull
            protected InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack, @NotNull IExtendedFluidTank fluidTank) {
                FluidStack fluidStack = fluidTank.getFluid();
                BlockState endState = this.getState(fluidStack);
                if (endState != null && fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() >= 1000) {
                    if (!level.isClientSide) {
                        if (!player.isCreative()) {
                            MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                        }
                        player.awardStat(Stats.FILL_CAULDRON);
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        level.setBlockAndUpdate(pos, endState);
                        SoundEvent emptySound = fluidStack.getFluidType().getSound(player, (BlockGetter)level, pos, SoundActions.BUCKET_EMPTY);
                        if (emptySound != null) {
                            level.playSound(null, pos, emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                        level.gameEvent(null, GameEvent.FLUID_PLACE, pos);
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.PASS;
            }
        };

        @NotNull
        public final InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack) {
            ItemBlockFluidTank tank;
            Item item;
            if (stack.getCount() == 1 && (item = stack.getItem()) instanceof ItemBlockFluidTank && ((Boolean)(tank = (ItemBlockFluidTank)item).getMode(stack)).booleanValue()) {
                IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return InteractionResult.PASS;
                }
                return this.interact(state, level, pos, player, hand, stack, fluidTank);
            }
            return InteractionResult.PASS;
        }

        @NotNull
        protected abstract InteractionResult interact(@NotNull BlockState var1, @NotNull Level var2, @NotNull BlockPos var3, @NotNull Player var4, @NotNull InteractionHand var5, @NotNull ItemStack var6, @NotNull IExtendedFluidTank var7);
    }

    public static class FluidTankItemDispenseBehavior
    extends DefaultDispenseItemBehavior {
        public static final FluidTankItemDispenseBehavior INSTANCE = new FluidTankItemDispenseBehavior();

        private FluidTankItemDispenseBehavior() {
        }

        @NotNull
        public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
            ItemBlockFluidTank tank;
            Item item;
            if (stack.getCount() == 1 && (item = stack.getItem()) instanceof ItemBlockFluidTank && ((Boolean)(tank = (ItemBlockFluidTank)item).getMode(stack)).booleanValue()) {
                IExtendedFluidTank fluidTank = ItemBlockFluidTank.getExtendedFluidTank(stack);
                if (fluidTank == null) {
                    return super.execute(source, stack);
                }
                ServerLevel world = source.level();
                BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                BlockState blockState = world.getBlockState(pos);
                FluidState fluidState = blockState.getFluidState();
                Optional sound = Optional.empty();
                if (!fluidState.isEmpty() && fluidState.isSource()) {
                    Fluid fluid = fluidState.getType();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    Block block = blockState.getBlock();
                    if (block instanceof IFluidBlock) {
                        IFluidBlock fluidBlock = (IFluidBlock)block;
                        fluidStack = fluidBlock.drain((Level)world, pos, IFluidHandler.FluidAction.SIMULATE);
                        if (!ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            return super.execute(source, stack);
                        }
                        fluidStack = fluidBlock.drain((Level)world, pos, IFluidHandler.FluidAction.EXECUTE);
                    } else if (block instanceof BucketPickup) {
                        BucketPickup bucketPickup = (BucketPickup)block;
                        if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                            BucketItem bucket;
                            ItemStack pickedUpStack = bucketPickup.pickupBlock(null, (LevelAccessor)world, pos, blockState);
                            if (pickedUpStack.isEmpty()) {
                                return super.execute(source, stack);
                            }
                            Item item2 = pickedUpStack.getItem();
                            if (item2 instanceof BucketItem && !ItemBlockFluidTank.validFluid(fluidTank, fluidStack = new FluidStack(fluid = (bucket = (BucketItem)item2).getFluid(), 1000))) {
                                Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", new Object[]{RegistryUtils.getName(fluidState.getType()), pos, world.dimension().location(), RegistryUtils.getName(fluid)});
                                return super.execute(source, stack);
                            }
                            sound = bucketPickup.getPickupSound(blockState);
                        }
                    }
                    if (ItemBlockFluidTank.validFluid(fluidTank, fluidStack)) {
                        tank.uncheckedGrow(fluidTank, fluidStack);
                        WorldUtils.playFillSound(null, (LevelAccessor)world, pos, fluidStack, sound.orElse(null));
                        world.gameEvent(null, GameEvent.FLUID_PICKUP, pos);
                        return stack;
                    }
                } else if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() >= 1000 && WorldUtils.tryPlaceContainedLiquid(null, (Level)world, pos, fluidTank.getFluid(), null)) {
                    MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                    world.gameEvent(null, GameEvent.FLUID_PLACE, pos);
                    return stack;
                }
            }
            return super.execute(source, stack);
        }
    }
}

