/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.transmitter;

import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.item.block.transmitter.ItemBlockTransporter;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockLogisticalTransporter
extends ItemBlockTransporter<TileEntityLogisticalTransporter> {
    public ItemBlockLogisticalTransporter(BlockLargeTransmitter<TileEntityLogisticalTransporter> block) {
        super(block);
    }

    @Override
    @NotNull
    public TransporterTier getTier() {
        return Attribute.getTier(this.getBlock(), TransporterTier.class);
    }

    @Override
    protected void addStats(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        float tickRate;
        super.addStats(stack, world, tooltip, flag);
        TransporterTier tier = this.getTier();
        int speed = tier.getSpeed();
        int pull = tier.getPullAmount();
        float f = tickRate = world == null ? 20.0f : world.tickRateManager().tickrate();
        if (tickRate > 0.0f) {
            speed = (int)((float)speed / (100.0f / tickRate));
            pull = (int)((float)pull * tickRate / 10.0f);
        } else {
            speed = 0;
            pull = 0;
        }
        tooltip.add((Component)MekanismLang.SPEED.translateColored(EnumColor.INDIGO, EnumColor.GRAY, speed));
        tooltip.add((Component)MekanismLang.PUMP_RATE.translateColored(EnumColor.INDIGO, EnumColor.GRAY, pull));
    }
}

