/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ItemArmoredJetpack
extends ItemJetpack
implements IAttributeRefresher {
    private static final ArmoredJetpackMaterial ARMORED_JETPACK_MATERIAL = new ArmoredJetpackMaterial();
    private final AttributeCache attributeCache;

    public ItemArmoredJetpack(Item.Properties properties) {
        super(ARMORED_JETPACK_MATERIAL, properties);
        this.attributeCache = new AttributeCache(this, MekanismConfig.gear.armoredJetpackArmor, MekanismConfig.gear.armoredJetpackToughness, MekanismConfig.gear.armoredJetpackKnockbackResistance);
    }

    @Override
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.armoredJetpack());
    }

    public int getDefense() {
        return this.getMaterial().getDefenseForType(this.getType());
    }

    public float getToughness() {
        return this.getMaterial().getToughness();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == this.getEquipmentSlot() ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = (UUID)ARMOR_MODIFIER_UUID_PER_TYPE.get(this.getType());
        builder.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.getDefense(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.getToughness(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.getMaterial().getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
    }

    @NothingNullByDefault
    private static class ArmoredJetpackMaterial
    extends ItemJetpack.JetpackMaterial {
        private ArmoredJetpackMaterial() {
        }

        @Override
        public int getDefenseForType(ArmorItem.Type armorType) {
            return armorType == ArmorItem.Type.CHESTPLATE ? MekanismConfig.gear.armoredJetpackArmor.getOrDefault() : 0;
        }

        @Override
        public String getName() {
            return "mekanism:jetpack_armored";
        }

        @Override
        public float getToughness() {
            return MekanismConfig.gear.armoredJetpackToughness.getOrDefault();
        }

        @Override
        public float getKnockbackResistance() {
            return MekanismConfig.gear.armoredJetpackKnockbackResistance.getOrDefault();
        }
    }
}

