/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Map;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ItemElectricBow
extends BowItem
implements IItemHUDProvider,
CreativeTabDeferredRegister.ICustomCreativeTabContents,
IModeItem.IAttachmentBasedModeItem<Boolean> {
    public ItemElectricBow(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).setNoRepair().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack))));
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            IEnergyContainer energyContainer = null;
            FloatingLong energyNeeded = FloatingLong.ZERO;
            if (!player.isCreative()) {
                energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong floatingLong = energyNeeded = (Boolean)this.getMode(stack) != false ? (FloatingLong)MekanismConfig.gear.electricBowEnergyUsageFire.get() : (FloatingLong)MekanismConfig.gear.electricBowEnergyUsage.get();
                if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                    return;
                }
            }
            boolean infinity = player.isCreative() || stack.getEnchantmentLevel(Enchantments.INFINITY_ARROWS) > 0;
            ItemStack ammo = player.getProjectile(stack);
            int charge = EventHooks.onArrowLoose((ItemStack)stack, (Level)world, (Player)player, (int)(this.getUseDuration(stack) - timeLeft), (!ammo.isEmpty() || infinity ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if (!ammo.isEmpty() || infinity) {
                ArrowItem arrow;
                Item item;
                boolean noConsume;
                float velocity = ItemElectricBow.getPowerForTime((int)charge);
                if ((double)velocity < 0.1) {
                    return;
                }
                if (ammo.isEmpty()) {
                    ammo = new ItemStack((ItemLike)Items.ARROW);
                }
                boolean bl = noConsume = player.isCreative() || (item = ammo.getItem()) instanceof ArrowItem && (arrow = (ArrowItem)item).isInfinite(ammo, stack, player);
                if (!world.isClientSide) {
                    int punch;
                    int power;
                    ArrowItem arrowitem = (ArrowItem)(ammo.getItem() instanceof ArrowItem ? ammo.getItem() : Items.ARROW);
                    AbstractArrow arrowEntity = arrowitem.createArrow(world, ammo, (LivingEntity)player);
                    arrowEntity = this.customArrow(arrowEntity, ammo);
                    arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f * velocity, 1.0f);
                    if (velocity == 1.0f) {
                        arrowEntity.setCritArrow(true);
                    }
                    if ((power = stack.getEnchantmentLevel(Enchantments.POWER_ARROWS)) > 0) {
                        arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + 0.5 * (double)power + 0.5);
                    }
                    if ((punch = stack.getEnchantmentLevel(Enchantments.PUNCH_ARROWS)) > 0) {
                        arrowEntity.setKnockback(punch);
                    }
                    if (stack.getEnchantmentLevel(Enchantments.FLAMING_ARROWS) > 0) {
                        arrowEntity.setSecondsOnFire(100);
                    }
                    if (energyContainer != null) {
                        energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    if (noConsume || player.isCreative() && (ammo.getItem() == Items.SPECTRAL_ARROW || ammo.getItem() == Items.TIPPED_ARROW)) {
                        arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    world.addFreshEntity((Entity)arrowEntity);
                }
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.random.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!noConsume && !player.isCreative()) {
                    ammo.shrink(1);
                    if (ammo.isEmpty()) {
                        player.getInventory().removeItem(ammo);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.FLAMING_ARROWS && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (enchantment == Enchantments.FLAMING_ARROWS && ((Boolean)this.getMode(stack)).booleanValue()) {
            return Math.max(1, super.getEnchantmentLevel(stack, enchantment));
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = super.getAllEnchantments(stack);
        if (((Boolean)this.getMode(stack)).booleanValue()) {
            enchantments.merge(Enchantments.FLAMING_ARROWS, 1, Math::max);
        }
        return enchantments;
    }

    @Override
    public AttachmentType<Boolean> getModeAttachment() {
        return (AttachmentType)MekanismAttachmentTypes.ELECTRIC_BOW_MODE.get();
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack))));
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    @Override
    public void addItems(CreativeModeTab.Output tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant(new ItemStack((ItemLike)this)));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = (Boolean)this.getMode(stack) == false;
            this.setMode(stack, player, newState);
            displayChange.sendMessage(player, newState, s -> MekanismLang.FIRE_MODE.translate(BooleanStateDisplay.OnOff.of(s, true)));
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return MekanismLang.FIRE_MODE.translateColored(EnumColor.PINK, BooleanStateDisplay.OnOff.of((Boolean)this.getMode(stack), true));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() != newStack.getItem();
    }
}

