/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.item.RateLimitEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemArmoredFreeRunners;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.StorageUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFreeRunners
extends ItemSpecialArmor
implements IItemHUDProvider,
CreativeTabDeferredRegister.ICustomCreativeTabContents,
IModeItem.IAttachmentBasedModeItem<FreeRunnerMode>,
IAttachmentAware {
    private static final FreeRunnerMaterial FREE_RUNNER_MATERIAL = new FreeRunnerMaterial();

    public ItemFreeRunners(Item.Properties properties) {
        this(FREE_RUNNER_MATERIAL, properties);
    }

    public ItemFreeRunners(ArmorMaterial material, Item.Properties properties) {
        super(material, ArmorItem.Type.BOOTS, properties.rarity(Rarity.RARE).setNoRepair());
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.freeRunners());
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        StorageUtils.addStoredEnergy(stack, tooltip, true);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, ((FreeRunnerMode)this.getMode(stack)).getTextComponent()));
    }

    @Override
    public void addItems(CreativeModeTab.Output tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant(new ItemStack((ItemLike)this)));
    }

    public boolean canWalkOnPowderedSnow(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    private int getFakeEnchantmentLevel(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        if (enchantment == Enchantments.SOUL_SPEED && this.getMode(stack) == FreeRunnerMode.NORMAL) {
            return 1;
        }
        return 0;
    }

    public int getEnchantmentLevel(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        return Math.max(this.getFakeEnchantmentLevel(stack, enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    @NotNull
    public Map<Enchantment, Integer> getAllEnchantments(@NotNull ItemStack stack) {
        Map enchantments = super.getAllEnchantments(stack);
        enchantments.merge(Enchantments.SOUL_SPEED, this.getFakeEnchantmentLevel(stack, Enchantments.SOUL_SPEED), Math::max);
        return enchantments;
    }

    @Override
    public void attachAttachments(IEventBus eventBus) {
        ContainerType.ENERGY.addDefaultContainer(eventBus, (Item)this, stack -> RateLimitEnergyContainer.create(MekanismConfig.gear.freeRunnerChargeRate, MekanismConfig.gear.freeRunnerMaxEnergy), MekanismConfig.gear);
    }

    @Override
    public AttachmentType<FreeRunnerMode> getModeAttachment() {
        return (AttachmentType)MekanismAttachmentTypes.FREE_RUNNER_MODE.get();
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        if (slotType == this.getEquipmentSlot()) {
            list.add((Component)MekanismLang.FREE_RUNNERS_MODE.translateColored(EnumColor.GRAY, ((FreeRunnerMode)this.getMode(stack)).getTextComponent()));
            StorageUtils.addStoredEnergy(stack, list, true, MekanismLang.FREE_RUNNERS_STORED);
        }
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        FreeRunnerMode newMode;
        FreeRunnerMode mode = (FreeRunnerMode)this.getMode(stack);
        if (mode != (newMode = (FreeRunnerMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, xva$0 -> MekanismLang.FREE_RUNNER_MODE_CHANGE.translate(xva$0));
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.getEquipmentSlot();
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        if (this instanceof ItemArmoredFreeRunners) {
            return super.getDefaultTooltipHideFlags(stack);
        }
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.getMask();
    }

    @NothingNullByDefault
    protected static class FreeRunnerMaterial
    extends BaseSpecialArmorMaterial {
        protected FreeRunnerMaterial() {
        }

        public String getName() {
            return "mekanism:free_runners";
        }
    }

    @NothingNullByDefault
    public static enum FreeRunnerMode implements IIncrementalEnum<FreeRunnerMode>,
    IHasTextComponent
    {
        NORMAL(MekanismLang.FREE_RUNNER_NORMAL, EnumColor.DARK_GREEN, true, true),
        SAFETY(MekanismLang.FREE_RUNNER_SAFETY, EnumColor.ORANGE, true, false),
        DISABLED(MekanismLang.FREE_RUNNER_DISABLED, EnumColor.DARK_RED, false, false);

        private static final FreeRunnerMode[] MODES;
        private final boolean preventsFallDamage;
        private final boolean providesStepBoost;
        private final ILangEntry langEntry;
        private final EnumColor color;

        private FreeRunnerMode(ILangEntry langEntry, EnumColor color, boolean preventsFallDamage, boolean providesStepBoost) {
            this.preventsFallDamage = preventsFallDamage;
            this.providesStepBoost = providesStepBoost;
            this.langEntry = langEntry;
            this.color = color;
        }

        public boolean preventsFallDamage() {
            return this.preventsFallDamage;
        }

        public boolean providesStepBoost() {
            return this.providesStepBoost;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translateColored(this.color);
        }

        @Override
        public FreeRunnerMode byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = FreeRunnerMode.values();
        }
    }
}

