/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.integration.gender.GenderCapabilityHelper;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class ItemHazmatSuitArmor
extends ArmorItem
implements ICapabilityAware {
    private static final HazmatMaterial HAZMAT_MATERIAL = new HazmatMaterial();

    public ItemHazmatSuitArmor(ArmorItem.Type armorType, Item.Properties properties) {
        super((ArmorMaterial)HAZMAT_MATERIAL, armorType, properties.rarity(Rarity.UNCOMMON));
    }

    public static double getShieldingByArmor(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> 0.25;
            case ArmorItem.Type.CHESTPLATE -> 0.4;
            case ArmorItem.Type.LEGGINGS -> 0.2;
            case ArmorItem.Type.BOOTS -> 0.15;
        };
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.getMask();
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.RADIATION_SHIELDING, (stack, ctx) -> RadiationShieldingHandler.create(ItemHazmatSuitArmor.getShieldingByArmor(this.getType())), new ItemLike[]{this});
        GenderCapabilityHelper.addGenderCapability(event, this);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return this.material.getEnchantmentValue() > 0 && super.isEnchantable(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isEnchantable(stack) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @NothingNullByDefault
    protected static class HazmatMaterial
    extends BaseSpecialArmorMaterial {
        protected HazmatMaterial() {
        }

        public String getName() {
            return "mekanism:hazmat";
        }
    }
}

