/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemArmoredJetpack;
import mekanism.common.item.gear.ItemGasArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismGases;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemJetpack
extends ItemGasArmor
implements IItemHUDProvider,
IJetpackItem,
IModeItem.IAttachmentBasedModeItem<IJetpackItem.JetpackMode> {
    private static final JetpackMaterial JETPACK_MATERIAL = new JetpackMaterial();

    public ItemJetpack(Item.Properties properties) {
        this(JETPACK_MATERIAL, properties);
    }

    public ItemJetpack(ArmorMaterial material, Item.Properties properties) {
        super(material, ArmorItem.Type.CHESTPLATE, properties.setNoRepair());
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.jetpack());
    }

    @Override
    protected CachedLongValue getMaxGas() {
        return MekanismConfig.gear.jetpackMaxGas;
    }

    @Override
    protected LongSupplier getFillRate() {
        return MekanismConfig.gear.jetpackFillRate;
    }

    @Override
    protected IGasProvider getGasType() {
        return MekanismGases.HYDROGEN;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, world, tooltip, flag);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, ((IJetpackItem.JetpackMode)this.getMode(stack)).getTextComponent()));
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        return this.hasGas(stack);
    }

    @Override
    public AttachmentType<IJetpackItem.JetpackMode> getModeAttachment() {
        return (AttachmentType)MekanismAttachmentTypes.JETPACK_MODE.get();
    }

    @Override
    public IJetpackItem.JetpackMode getJetpackMode(ItemStack stack) {
        return (IJetpackItem.JetpackMode)this.getMode(stack);
    }

    @Override
    public double getJetpackThrust(ItemStack stack) {
        return 0.15;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        this.useGas(stack, 1L);
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        if (slotType == this.getEquipmentSlot()) {
            ItemJetpack jetpack = (ItemJetpack)stack.getItem();
            list.add((Component)MekanismLang.JETPACK_MODE.translateColored(EnumColor.DARK_GRAY, jetpack.getMode(stack)));
            GasStack stored = GasStack.EMPTY;
            long capacity = 1L;
            IGasHandler gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(stack);
            if (gasHandlerItem != null && gasHandlerItem.getTanks() > 0) {
                stored = (GasStack)gasHandlerItem.getChemicalInTank(0);
                capacity = gasHandlerItem.getTankCapacity(0);
            }
            list.add((Component)MekanismLang.JETPACK_STORED.translateColored(EnumColor.DARK_GRAY, EnumColor.ORANGE, stored.getAmount(), String.format("%.0f", 100.0 * (double)stored.getAmount() / (double)capacity)));
        }
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        IJetpackItem.JetpackMode newMode;
        IJetpackItem.JetpackMode mode = (IJetpackItem.JetpackMode)this.getMode(stack);
        if (mode != (newMode = (IJetpackItem.JetpackMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            displayChange.sendMessage(player, newMode, xva$0 -> MekanismLang.JETPACK_MODE_CHANGE.translate(xva$0));
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.getEquipmentSlot();
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        if (this instanceof ItemArmoredJetpack) {
            return super.getDefaultTooltipHideFlags(stack);
        }
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.getMask();
    }

    @NothingNullByDefault
    protected static class JetpackMaterial
    extends BaseSpecialArmorMaterial {
        protected JetpackMaterial() {
        }

        public String getName() {
            return "mekanism:jetpack";
        }
    }
}

