/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.datamaps.MekaSuitAbsorption;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.IAttachmentAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.item.ChemicalTankSpec;
import mekanism.common.capabilities.chemical.variable.RateLimitGasTank;
import mekanism.common.capabilities.energy.item.NoClampRateLimitEnergyContainer;
import mekanism.common.capabilities.fluid.item.FluidTankSpec;
import mekanism.common.capabilities.fluid.item.RateLimitFluidTank;
import mekanism.common.capabilities.laser.item.LaserDissipationHandler;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.gear.mekasuit.ModuleElytraUnit;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registries.MekanismDataMapTypes;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaSuitArmor
extends ItemSpecialArmor
implements IModuleContainerItem,
IJetpackItem,
IAttributeRefresher,
CreativeTabDeferredRegister.ICustomCreativeTabContents,
IAttachmentAware {
    private static final AttributeModifier CREATIVE_FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("018e6622-7fc7-7334-af44-9f13564edb84"), "mekasuit_gravitational_modulation", 1.0, AttributeModifier.Operation.ADDITION);
    private static final MekaSuitMaterial MEKASUIT_MATERIAL = new MekaSuitMaterial();
    private final AttributeCache attributeCache;
    private final AttributeCache attributeCacheWithFlight;
    private final List<ChemicalTankSpec<Gas>> gasTankSpecs = new ArrayList<ChemicalTankSpec<Gas>>();
    private final List<ChemicalTankSpec<Gas>> gasTankSpecsView = Collections.unmodifiableList(this.gasTankSpecs);
    private final List<FluidTankSpec> fluidTankSpecs = new ArrayList<FluidTankSpec>();
    private final List<FluidTankSpec> fluidTankSpecsView = Collections.unmodifiableList(this.fluidTankSpecs);
    private final float absorption;
    private final double laserDissipation;
    private final double laserRefraction;

    public ItemMekaSuitArmor(ArmorItem.Type armorType, Item.Properties properties) {
        super(MEKASUIT_MATERIAL, armorType, properties.rarity(Rarity.EPIC).setNoRepair().stacksTo(1));
        CachedIntValue armorConfig = switch (armorType) {
            case ArmorItem.Type.HELMET -> {
                this.fluidTankSpecs.add(FluidTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitNutritionalTransferRate, MekanismConfig.gear.mekaSuitNutritionalMaxStorage, fluid -> fluid.is((Fluid)MekanismFluids.NUTRITIONAL_PASTE.getFluid()), stack -> this.hasModule((ItemStack)stack, MekanismModules.NUTRITIONAL_INJECTION_UNIT)));
                this.absorption = 0.15f;
                this.laserDissipation = 0.15;
                this.laserRefraction = 0.2;
                yield MekanismConfig.gear.mekaSuitHelmetArmor;
            }
            case ArmorItem.Type.CHESTPLATE -> {
                this.gasTankSpecs.add(ChemicalTankSpec.createFillOnly((LongSupplier)MekanismConfig.gear.mekaSuitJetpackTransferRate, stack -> {
                    IModule<ModuleJetpackUnit> module = IModuleHelper.INSTANCE.load((ItemStack)stack, MekanismModules.JETPACK_UNIT);
                    return module != null ? MekanismConfig.gear.mekaSuitJetpackMaxStorage.get() * (long)module.getInstalledCount() : 0L;
                }, gas -> gas == MekanismGases.HYDROGEN.get(), stack -> this.hasModule((ItemStack)stack, MekanismModules.JETPACK_UNIT)));
                this.absorption = 0.4f;
                this.laserDissipation = 0.3;
                this.laserRefraction = 0.4;
                yield MekanismConfig.gear.mekaSuitBodyArmorArmor;
            }
            case ArmorItem.Type.LEGGINGS -> {
                this.absorption = 0.3f;
                this.laserDissipation = 0.1875;
                this.laserRefraction = 0.25;
                yield MekanismConfig.gear.mekaSuitPantsArmor;
            }
            case ArmorItem.Type.BOOTS -> {
                this.absorption = 0.15f;
                this.laserDissipation = 0.1125;
                this.laserRefraction = 0.15;
                yield MekanismConfig.gear.mekaSuitBootsArmor;
            }
            default -> throw new IllegalArgumentException("Unknown Equipment Slot Type");
        };
        this.attributeCache = new AttributeCache(this, armorConfig, MekanismConfig.gear.mekaSuitToughness, MekanismConfig.gear.mekaSuitKnockbackResistance);
        this.attributeCacheWithFlight = new AttributeCache(builder -> {
            this.addToBuilder((ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder);
            builder.put((Object)((Attribute)NeoForgeMod.CREATIVE_FLIGHT.value()), (Object)CREATIVE_FLIGHT_MODIFIER);
        }, armorConfig, MekanismConfig.gear.mekaSuitToughness, MekanismConfig.gear.mekaSuitKnockbackResistance);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.mekaSuit());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        ModuleHelper.INSTANCE.dropModuleContainerContents(item, damageSource);
    }

    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            if (!this.gasTankSpecs.isEmpty()) {
                StorageUtils.addStoredGas(stack, tooltip, true, false);
            }
            if (!this.fluidTankSpecs.isEmpty()) {
                StorageUtils.addStoredFluid(stack, tooltip, true);
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
        }
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    public boolean isEnderMask(@NotNull ItemStack stack, @NotNull Player player, @NotNull EnderMan enderman) {
        return this.type == ArmorItem.Type.HELMET;
    }

    public boolean canWalkOnPowderedSnow(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return this.type == ArmorItem.Type.BOOTS;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || this.hasInstalledModules(stack);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainerNullable(stack);
        int moduleLevel = container == null ? 0 : container.getModuleEnchantmentLevel(enchantment);
        return Math.max(moduleLevel, super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = super.getAllEnchantments(stack);
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainerNullable(stack);
        if (container != null) {
            for (Map.Entry<Enchantment, Integer> entry : container.moduleBasedEnchantments().entrySet()) {
                enchantments.merge(entry.getKey(), entry.getValue(), Math::max);
            }
        }
        return enchantments;
    }

    @Override
    public void addItems(CreativeModeTab.Output tabOutput) {
        tabOutput.accept(StorageUtils.getFilledEnergyVariant(new ItemStack((ItemLike)this)));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (slotId >= 36 && slotId < 40 && entity instanceof Player) {
            Player player = (Player)entity;
            ModuleContainer container = ModuleHelper.get().getModuleContainerNullable(stack);
            if (container != null) {
                for (Module<?> module : container.modules()) {
                    module.tick(player);
                }
            }
        }
    }

    @Override
    public void attachAttachments(IEventBus eventBus) {
        ContainerType.ENERGY.addDefaultContainer(eventBus, (Item)this, stack -> NoClampRateLimitEnergyContainer.create(() -> ModuleEnergyUnit.getChargeRate(stack, (FloatingLong)MekanismConfig.gear.mekaSuitBaseChargeRate.get()), () -> ModuleEnergyUnit.getEnergyCapacity(stack, (FloatingLong)MekanismConfig.gear.mekaSuitBaseEnergyCapacity.get())), MekanismConfig.gear);
        if (!this.gasTankSpecs.isEmpty()) {
            ContainerType.GAS.addDefaultContainers(eventBus, (Item)this, stack -> {
                ArrayList<IGasTank> list = new ArrayList<IGasTank>(this.gasTankSpecs.size());
                for (ChemicalTankSpec<Gas> spec : this.gasTankSpecs) {
                    list.add(spec.createTank(RateLimitGasTank::create, (ItemStack)stack));
                }
                return list;
            }, MekanismConfig.gear);
        }
        if (!this.fluidTankSpecs.isEmpty()) {
            ContainerType.FLUID.addDefaultContainers(eventBus, (Item)this, stack -> {
                ArrayList<RateLimitFluidTank> list = new ArrayList<RateLimitFluidTank>(this.fluidTankSpecs.size());
                for (FluidTankSpec spec : this.fluidTankSpecs) {
                    list.add(spec.createTank(RateLimitFluidTank::create, (ItemStack)stack));
                }
                return list;
            }, MekanismConfig.gear);
        }
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        super.attachCapabilities(event);
        event.registerItem(Capabilities.RADIATION_SHIELDING, (stack, ctx) -> {
            if (!MekanismConfig.gear.isLoaded() || !this.isModuleEnabled((ItemStack)stack, MekanismModules.RADIATION_SHIELDING_UNIT)) {
                return null;
            }
            return RadiationShieldingHandler.create(ItemHazmatSuitArmor.getShieldingByArmor(this.getType()));
        }, new ItemLike[]{this});
        event.registerItem(Capabilities.LASER_DISSIPATION, (stack, ctx) -> this.isModuleEnabled((ItemStack)stack, MekanismModules.LASER_DISSIPATION_UNIT) ? LaserDissipationHandler.create(this.laserDissipation, this.laserRefraction) : null, new ItemLike[]{this});
    }

    public List<ChemicalTankSpec<Gas>> getGasTankSpecs() {
        return this.gasTankSpecsView;
    }

    public List<FluidTankSpec> getFluidTankSpecs() {
        return this.fluidTankSpecsView;
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.getEquipmentSlot() && this.getModules(stack).stream().anyMatch(IModule::handlesModeChange);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        IModule<ModuleElytraUnit> elytra;
        IModuleContainer container;
        if (this.getType() == ArmorItem.Type.CHESTPLATE && !entity.isShiftKeyDown() && (container = this.moduleContainer(stack)) != null && (elytra = container.getIfEnabled(MekanismModules.ELYTRA_UNIT)) != null && elytra.canUseEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get())) {
            IModule<ModuleJetpackUnit> jetpack = container.getIfEnabled(MekanismModules.JETPACK_UNIT);
            return jetpack == null || jetpack.getCustomInstance().getMode() != IJetpackItem.JetpackMode.HOVER || StorageUtils.getContainedGas(stack, MekanismGases.HYDROGEN).isEmpty();
        }
        return false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTicks;
        if (!entity.level().isClientSide && (nextFlightTicks = flightTicks + 1) % 10 == 0) {
            IModule module;
            if (nextFlightTicks % 20 == 0 && (module = this.getEnabledModule(stack, MekanismModules.ELYTRA_UNIT)) != null) {
                module.useEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get());
            }
            entity.gameEvent(GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        if (this.type == ArmorItem.Type.CHESTPLATE) {
            if (this.isModuleEnabled(stack, MekanismModules.JETPACK_UNIT)) {
                return ChemicalUtil.hasChemical(stack, (Gas)MekanismGases.HYDROGEN.get());
            }
            return this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && module.getData().isExclusive(ModuleData.ExclusiveFlag.OVERRIDE_JUMP.getMask()));
        }
        return false;
    }

    @Override
    public IJetpackItem.JetpackMode getJetpackMode(ItemStack stack) {
        IModule module = this.getEnabledModule(stack, MekanismModules.JETPACK_UNIT);
        if (module != null) {
            return ((ModuleJetpackUnit)module.getCustomInstance()).getMode();
        }
        return IJetpackItem.JetpackMode.DISABLED;
    }

    @Override
    public double getJetpackThrust(ItemStack stack) {
        IModule module = this.getEnabledModule(stack, MekanismModules.JETPACK_UNIT);
        if (module != null) {
            GasStack containedGas;
            float thrustMultiplier = ((ModuleJetpackUnit)module.getCustomInstance()).getThrustMultiplier();
            int neededGas = Mth.ceil((float)thrustMultiplier);
            if (neededGas > 1 && (long)neededGas > (containedGas = StorageUtils.getContainedGas(stack, MekanismGases.HYDROGEN)).getAmount()) {
                thrustMultiplier = containedGas.getAmount();
            }
            return 0.15 * (double)thrustMultiplier;
        }
        return 0.0;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        IGasHandler gasHandlerItem;
        IModule module = this.getEnabledModule(stack, MekanismModules.JETPACK_UNIT);
        if (module != null && (gasHandlerItem = (IGasHandler)Capabilities.GAS.getCapability(stack)) != null) {
            int amount = Mth.ceil((float)((ModuleJetpackUnit)module.getCustomInstance()).getThrustMultiplier());
            gasHandlerItem.extractChemical(MekanismGases.HYDROGEN.getStack(amount), Action.EXECUTE);
        }
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == this.getEquipmentSlot()) {
            if (slot == EquipmentSlot.CHEST && CommonPlayerTickHandler.isGravitationalModulationReady(stack)) {
                return (Multimap)this.attributeCacheWithFlight.get();
            }
            return (Multimap)this.attributeCache.get();
        }
        return ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = (UUID)ARMOR_MODIFIER_UUID_PER_TYPE.get(this.getType());
        builder.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.getDefense(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.getToughness(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.getMaterial().getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
    }

    public int getDefense() {
        return this.getMaterial().getDefenseForType(this.getType());
    }

    public float getToughness() {
        return this.getMaterial().getToughness();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() != newStack.getItem();
    }

    public static float getDamageAbsorbed(Player player, DamageSource source, float amount) {
        return ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, null);
    }

    public static boolean tryAbsorbAll(Player player, DamageSource source, float amount) {
        ArrayList<Runnable> energyUsageCallbacks = new ArrayList<Runnable>(4);
        if (ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, energyUsageCallbacks) >= 1.0f) {
            for (Runnable energyUsageCallback : energyUsageCallbacks) {
                energyUsageCallback.run();
            }
            return true;
        }
        return false;
    }

    private static float getDamageAbsorbed(Player player, DamageSource source, float amount, @Nullable List<Runnable> energyUseCallbacks) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float ratioAbsorbed = 0.0f;
        ArrayList<FoundArmorDetails> armorDetails = new ArrayList<FoundArmorDetails>();
        for (Object stack : player.getArmorSlots()) {
            float absorption;
            ICustomModule.ModuleDamageAbsorbInfo damageAbsorbInfo;
            IModule module;
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemMekaSuitArmor)) continue;
            ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, 0);
            if (energyContainer == null) continue;
            FoundArmorDetails details = new FoundArmorDetails(energyContainer, armor);
            armorDetails.add(details);
            Iterator iterator = details.armor.getModules((ItemStack)stack).iterator();
            while (!(!iterator.hasNext() || (module = (IModule)iterator.next()).isEnabled() && (damageAbsorbInfo = ItemMekaSuitArmor.getModuleDamageAbsorbInfo(module, source)) != null && (ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = damageAbsorbInfo.absorptionRatio().getAsFloat(), ratioAbsorbed, damageAbsorbInfo.energyCost())) >= 1.0f)) {
            }
            if (!(ratioAbsorbed >= 1.0f)) continue;
            break;
        }
        if (ratioAbsorbed < 1.0f) {
            Float absorbRatio = null;
            for (FoundArmorDetails details : armorDetails) {
                float absorption;
                if (absorbRatio == null) {
                    if (source.is(Tags.DamageTypes.IS_TECHNICAL) || !source.is(MekanismTags.DamageTypes.MEKASUIT_ALWAYS_SUPPORTED) && source.is(DamageTypeTags.BYPASSES_ARMOR)) break;
                    MekaSuitAbsorption absorptionData = null;
                    if (source.typeHolder().unwrapKey().isPresent()) {
                        absorptionData = (MekaSuitAbsorption)source.typeHolder().getData(MekanismDataMapTypes.MEKA_SUIT_ABSORPTION);
                    } else {
                        Optional registry = player.level().registryAccess().registry(Registries.DAMAGE_TYPE);
                        if (registry.isPresent()) {
                            absorptionData = (MekaSuitAbsorption)((Registry)registry.get()).wrapAsHolder((Object)source.type()).getData(MekanismDataMapTypes.MEKA_SUIT_ABSORPTION);
                        }
                    }
                    absorbRatio = absorptionData != null ? Float.valueOf(absorptionData.absorption()) : Float.valueOf(MekanismConfig.gear.mekaSuitUnspecifiedDamageRatio.get());
                    if (absorbRatio.floatValue() == 0.0f) break;
                }
                if (!((ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = details.armor.absorption * absorbRatio.floatValue(), ratioAbsorbed, MekanismConfig.gear.mekaSuitEnergyUsageDamage)) >= 1.0f)) continue;
                break;
            }
        }
        for (FoundArmorDetails details : armorDetails) {
            if (details.usageInfo.energyUsed.isZero()) continue;
            if (energyUseCallbacks == null) {
                details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL);
                continue;
            }
            energyUseCallbacks.add(details);
        }
        return Math.min(ratioAbsorbed, 1.0f);
    }

    @Nullable
    private static <MODULE extends ICustomModule<MODULE>> ICustomModule.ModuleDamageAbsorbInfo getModuleDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return module.getCustomInstance().getDamageAbsorbInfo(module, damageSource);
    }

    private static float absorbDamage(EnergyUsageInfo usageInfo, float amount, float absorption, float currentAbsorbed, FloatingLongSupplier energyCost) {
        float toAbsorb = amount * (absorption = Math.min(1.0f - currentAbsorbed, absorption));
        if (toAbsorb > 0.0f) {
            FloatingLong usage = energyCost.get().multiply(toAbsorb);
            if (usage.isZero()) {
                return absorption;
            }
            if (usageInfo.energyAvailable.greaterOrEqual(usage)) {
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usage);
                usageInfo.energyAvailable = usageInfo.energyAvailable.minusEqual(usage);
                return absorption;
            }
            if (!usageInfo.energyAvailable.isZero()) {
                float absorbedPercent = usageInfo.energyAvailable.divide(usage).floatValue();
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usageInfo.energyAvailable);
                usageInfo.energyAvailable = FloatingLong.ZERO;
                return absorption * absorbedPercent;
            }
        }
        return 0.0f;
    }

    protected static class MekaSuitMaterial
    extends BaseSpecialArmorMaterial {
        protected MekaSuitMaterial() {
        }

        @Override
        public int getDefenseForType(@NotNull ArmorItem.Type armorType) {
            return switch (armorType) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS -> MekanismConfig.gear.mekaSuitBootsArmor.getOrDefault();
                case ArmorItem.Type.LEGGINGS -> MekanismConfig.gear.mekaSuitPantsArmor.getOrDefault();
                case ArmorItem.Type.CHESTPLATE -> MekanismConfig.gear.mekaSuitBodyArmorArmor.getOrDefault();
                case ArmorItem.Type.HELMET -> MekanismConfig.gear.mekaSuitHelmetArmor.getOrDefault();
            };
        }

        @Override
        public float getToughness() {
            return MekanismConfig.gear.mekaSuitToughness.getOrDefault();
        }

        @Override
        public float getKnockbackResistance() {
            return MekanismConfig.gear.mekaSuitKnockbackResistance.getOrDefault();
        }

        @NotNull
        public String getName() {
            return "mekanism:mekasuit";
        }
    }

    private static class FoundArmorDetails
    implements Runnable {
        private final IEnergyContainer energyContainer;
        private final EnergyUsageInfo usageInfo;
        private final ItemMekaSuitArmor armor;

        public FoundArmorDetails(IEnergyContainer energyContainer, ItemMekaSuitArmor armor) {
            this.energyContainer = energyContainer;
            this.usageInfo = new EnergyUsageInfo(energyContainer.getEnergy());
            this.armor = armor;
        }

        @Override
        public void run() {
            this.energyContainer.extract(this.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        }
    }

    private static class EnergyUsageInfo {
        private FloatingLong energyAvailable;
        private FloatingLong energyUsed = FloatingLong.ZERO;

        public EnergyUsageInfo(FloatingLong energyAvailable) {
            this.energyAvailable = energyAvailable.copy();
        }
    }
}

