/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.item.NoClampRateLimitEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IBlastingItem;
import mekanism.common.content.gear.IRadialModuleContainerItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.gear.mekatool.ModuleAttackAmplificationUnit;
import mekanism.common.content.gear.mekatool.ModuleBlastingUnit;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.content.gear.mekatool.ModuleVeinMiningUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaTool
extends ItemEnergized
implements IRadialModuleContainerItem,
IBlastingItem {
    private static final ResourceLocation RADIAL_ID = Mekanism.rl("meka_tool");
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(ModuleAttackAmplificationUnit.AttackDamage.values().length);

    public ItemMekaTool(Item.Properties properties) {
        super(MekanismConfig.gear.mekaToolBaseChargeRate, MekanismConfig.gear.mekaToolBaseEnergyCapacity, properties.rarity(Rarity.EPIC).setNoRepair());
    }

    public boolean isCorrectToolForDrops(@NotNull BlockState state) {
        return true;
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        ModuleHelper.INSTANCE.dropModuleContainerContents(item, damageSource);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()));
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        if (ItemAtomicDisassembler.ALWAYS_SUPPORTED_ACTIONS.contains(action)) {
            IModuleContainer container = this.moduleContainer(stack);
            return container != null && ItemMekaTool.hasEnergyForDigAction(container, StorageUtils.getEnergyContainer(stack, 0));
        }
        for (IModule module : this.getModules(stack)) {
            if (!module.isEnabled() || !this.canPerformAction(module, action)) continue;
            return true;
        }
        return false;
    }

    private <MODULE extends ICustomModule<MODULE>> boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return module.getCustomInstance().canPerformAction(module, action);
    }

    public static boolean hasEnergyForDigAction(IModuleContainer container, @Nullable IEnergyContainer energyContainer) {
        if (energyContainer != null) {
            FloatingLong energyAvailable;
            FloatingLong energyRequired = ItemMekaTool.getDestroyEnergy(container, 0.0f, container.hasEnabled(MekanismModules.SILK_TOUCH_UNIT));
            return energyRequired.smallerOrEqual(energyAvailable = energyContainer.getEnergy()) || !energyAvailable.divide(energyRequired).isZero();
        }
        return false;
    }

    public static FloatingLong getDestroyEnergy(IModuleContainer container, float hardness, boolean silk) {
        return ItemMekaTool.getDestroyEnergy(ItemMekaTool.getDestroyEnergy(container, silk), hardness);
    }

    private static FloatingLong getDestroyEnergy(IModuleContainer container, boolean silk) {
        FloatingLong destroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
        IModule<ModuleExcavationEscalationUnit> module = container.getIfEnabled(MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getCustomInstance().getEfficiency();
        return destroyEnergy.multiply(efficiency);
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || this.hasInstalledModules(stack);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainerNullable(stack);
        int moduleLevel = container == null ? 0 : container.getModuleEnchantmentLevel(enchantment);
        return Math.max(moduleLevel, super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = super.getAllEnchantments(stack);
        IModuleContainer container = IModuleHelper.INSTANCE.getModuleContainerNullable(stack);
        if (container != null) {
            for (Map.Entry<Enchantment, Integer> entry : container.moduleBasedEnchantments().entrySet()) {
                enchantments.merge(entry.getKey(), entry.getValue(), Math::max);
            }
        }
        return enchantments;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        for (IModule module : this.getModules(context.getItemInHand())) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleUse(module, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.useOn(context);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleUse(IModule<MODULE> module, UseOnContext context) {
        return module.getCustomInstance().onItemUse(module, context);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        for (IModule module : this.getModules(stack)) {
            InteractionResult result;
            if (!module.isEnabled() || (result = this.onModuleInteract(module, player, entity, hand)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }

    private <MODULE extends ICustomModule<MODULE>> InteractionResult onModuleInteract(IModule<MODULE> module, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        return module.getCustomInstance().onInteract(module, player, entity, hand);
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = ItemMekaTool.getDestroyEnergy(stack, state.destroySpeed, this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return MekanismConfig.gear.mekaToolBaseEfficiency.get() * energyAvailable.divide(energyRequired).floatValue();
        }
        IModule module = this.getEnabledModule(stack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        return module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : ((ModuleExcavationEscalationUnit)module.getCustomInstance()).getEfficiency();
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            FloatingLong energyRequired = ItemMekaTool.getDestroyEnergy(stack, state.getDestroySpeed((BlockGetter)world, pos), this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT));
            energyContainer.extract(energyRequired, Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        IEnergyContainer energyContainer;
        int unitDamage;
        IModule attackAmplificationUnit = this.getEnabledModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0 && (energyContainer = StorageUtils.getEnergyContainer(stack, 0)) != null && !energyContainer.isEmpty()) {
            energyContainer.extract(((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    @Override
    public Map<BlockPos, BlockState> getBlastedBlocks(Level world, Player player, ItemStack stack, BlockPos pos, BlockState state) {
        int radius;
        IModule blastingUnit;
        if (!player.isShiftKeyDown() && (blastingUnit = this.getEnabledModule(stack, MekanismModules.BLASTING_UNIT)) != null && (radius = ((ModuleBlastingUnit)blastingUnit.getCustomInstance()).getBlastRadius()) > 0 && IBlastingItem.canBlastBlock(world, pos, state)) {
            return IBlastingItem.findPositions(world, pos, player, radius);
        }
        return Collections.emptyMap();
    }

    private Object2IntMap<BlockPos> getVeinedBlocks(Level world, ItemStack stack, Map<BlockPos, BlockState> blocks, Reference2BooleanMap<Block> oreTracker) {
        IModule veinMiningUnit = this.getEnabledModule(stack, MekanismModules.VEIN_MINING_UNIT);
        if (veinMiningUnit != null) {
            ModuleVeinMiningUnit customInstance = (ModuleVeinMiningUnit)veinMiningUnit.getCustomInstance();
            return ModuleVeinMiningUnit.findPositions(world, blocks, customInstance.isExtended() ? customInstance.getExcavationRange() : 0, oreTracker);
        }
        return (Object2IntMap)blocks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, be -> 0, (l, r) -> l, Object2IntArrayMap::new));
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.level().isClientSide || player.isCreative()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            Reference2BooleanMap oreTracker;
            Map<BlockPos, BlockState> blocks;
            Object2IntMap<BlockPos> veinedBlocks;
            Level world = player.level();
            BlockState state = world.getBlockState(pos);
            boolean silk = this.isModuleEnabled(stack, MekanismModules.SILK_TOUCH_UNIT);
            FloatingLong modDestroyEnergy = ItemMekaTool.getDestroyEnergy(stack, silk);
            FloatingLong energyRequired = ItemMekaTool.getDestroyEnergy(modDestroyEnergy, state.getDestroySpeed((BlockGetter)world, pos));
            if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && !(veinedBlocks = this.getVeinedBlocks(world, stack, blocks = (blocks = this.getBlastedBlocks(world, player, stack, pos, state)).isEmpty() && ModuleVeinMiningUnit.canVeinBlock(state) ? Map.of(pos, state) : blocks, (Reference2BooleanMap<Block>)(oreTracker = (Reference2BooleanMap)blocks.values().stream().collect(Collectors.toMap(BlockBehaviour.BlockStateBase::getBlock, bs -> bs.is(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE), (l, r) -> l, Reference2BooleanArrayMap::new))))).isEmpty()) {
                FloatingLong baseDestroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
                MekanismUtils.veinMineArea(energyContainer, energyRequired, modDestroyEnergy, baseDestroyEnergy, world, pos, (ServerPlayer)player, stack, this, veinedBlocks, ItemMekaTool::getDestroyEnergy, (base, hardness, distance, bs) -> ItemMekaTool.getDestroyEnergy(base, hardness).multiply(0.5 * Math.pow(distance, bs.is(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE) ? 1.5 : 2.0)));
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private static FloatingLong getDestroyEnergy(boolean silk) {
        return silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
    }

    public static FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        return ItemMekaTool.getDestroyEnergy(ItemMekaTool.getDestroyEnergy(itemStack, silk), hardness);
    }

    private static FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private static FloatingLong getDestroyEnergy(ItemStack itemStack, boolean silk) {
        FloatingLong destroyEnergy = ItemMekaTool.getDestroyEnergy(silk);
        IModule<ModuleExcavationEscalationUnit> module = IModuleHelper.INSTANCE.getIfEnabled(itemStack, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        float efficiency = module == null ? MekanismConfig.gear.mekaToolBaseEfficiency.get() : module.getCustomInstance().getEfficiency();
        return destroyEnergy.multiply(efficiency);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            int unitDamage = 0;
            IModule attackAmplificationUnit = this.getEnabledModule(stack, MekanismModules.ATTACK_AMPLIFICATION_UNIT);
            if (attackAmplificationUnit != null && (unitDamage = ((ModuleAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getDamage()) > 0) {
                FloatingLong energy;
                FloatingLong energyCost = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageWeapon.get()).multiply((double)unitDamage / 4.0);
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong floatingLong = energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
                if (energy.smallerThan(energyCost)) {
                    double bonusDamage = (double)unitDamage * energy.divideToLevel(energyCost);
                    if (bonusDamage > 0.0) {
                        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)MekanismConfig.gear.mekaToolBaseDamage.get() + bonusDamage, AttributeModifier.Operation.ADDITION));
                        builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
                        return builder.build();
                    }
                    unitDamage = 0;
                }
            }
            return (Multimap)((AttributeCache)this.attributeCaches.computeIfAbsent(unitDamage, damage -> new AttributeCache(builder -> {
                builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)(MekanismConfig.gear.mekaToolBaseDamage.get() + damage), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", MekanismConfig.gear.mekaToolAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }, MekanismConfig.gear.mekaToolBaseDamage, MekanismConfig.gear.mekaToolAttackSpeed))).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        IModule module;
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide() && (module = this.getEnabledModule(stack, MekanismModules.TELEPORTATION_UNIT)) != null) {
            BlockPos pos;
            BlockHitResult result = MekanismUtils.rayTrace(player, MekanismConfig.gear.mekaToolMaxTeleportReach.get());
            if ((!((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() || result.getType() != HitResult.Type.MISS) && this.isValidDestinationBlock(world, (pos = result.getBlockPos()).above()) && this.isValidDestinationBlock(world, pos.above(2))) {
                double targetZ;
                double targetY;
                double distance = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                if (distance < 5.0) {
                    return InteractionResultHolder.pass((Object)stack);
                }
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                FloatingLong energyNeeded = ((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageTeleport.get()).multiply(distance / 10.0);
                if (energyContainer == null || energyContainer.getEnergy().smallerThan(energyNeeded)) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                double targetX = (double)pos.getX() + 0.5;
                MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.getY() + 1.5, targetZ = (double)pos.getZ() + 0.5, stack, result);
                if (((MekanismTeleportEvent.MekaTool)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                    return InteractionResultHolder.fail((Object)stack);
                }
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
                if (player.isPassenger()) {
                    player.dismountTo(targetX, targetY, targetZ);
                } else {
                    player.teleportTo(targetX, targetY, targetZ);
                }
                player.resetFallDistance();
                PacketUtils.sendToAllTracking(new PacketPortalFX(pos.above()), world, pos);
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private boolean isValidDestinationBlock(Level world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || MekanismUtils.isLiquidBlock(blockState.getBlock());
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    protected IEnergyContainer getDefaultEnergyContainer(ItemStack stack) {
        return NoClampRateLimitEnergyContainer.create(() -> ModuleEnergyUnit.getChargeRate(stack, (FloatingLong)MekanismConfig.gear.mekaToolBaseChargeRate.get()), () -> ModuleEnergyUnit.getEnergyCapacity(stack, (FloatingLong)MekanismConfig.gear.mekaToolBaseEnergyCapacity.get()), (Predicate<AutomationType>)this.canExtract, this.canInsert);
    }

    @Override
    public ResourceLocation getRadialIdentifier() {
        return RADIAL_ID;
    }
}

