/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.integration.gender.GenderCapabilityHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public abstract class ItemSpecialArmor
extends ArmorItem
implements ICapabilityAware {
    protected ItemSpecialArmor(ArmorMaterial material, ArmorItem.Type armorType, Item.Properties properties) {
        super(material, armorType, properties);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "mekanism:render/null_armor.png";
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return this.material.getEnchantmentValue() > 0 && super.isEnchantable(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.isEnchantable(stack) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        GenderCapabilityHelper.addGenderCapability(event, this);
    }
}

