/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.Optional;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public interface IColoredItem {
    default public void syncColorWithFrequency(ItemStack stack) {
        Object FREQ = ((FrequencyAware)stack.getData(MekanismAttachmentTypes.FREQUENCY_AWARE)).getFrequency();
        if (FREQ instanceof IColorableFrequency) {
            IColorableFrequency frequency = (IColorableFrequency)FREQ;
            stack.setData(MekanismAttachmentTypes.COLORABLE, Optional.of(frequency.getColor()));
        } else {
            stack.removeData(MekanismAttachmentTypes.COLORABLE);
        }
    }

    public static boolean supports(IAttachmentHolder attachmentHolder) {
        ItemStack stack;
        return attachmentHolder instanceof ItemStack && (stack = (ItemStack)attachmentHolder).getItem() instanceof IColoredItem;
    }
}

