/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.function.Predicate;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.IHasModeIcon;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface IJetpackItem {
    public boolean canUseJetpack(ItemStack var1);

    public JetpackMode getJetpackMode(ItemStack var1);

    public double getJetpackThrust(ItemStack var1);

    public void useJetpackFuel(ItemStack var1);

    @NotNull
    public static ItemStack getActiveJetpack(LivingEntity entity) {
        Player player;
        if (entity.isPassenger()) {
            return ItemStack.EMPTY;
        }
        ItemStack jetpack = IJetpackItem.getJetpack(entity, stack -> {
            IJetpackItem jetpackItem;
            Item patt3327$temp = stack.getItem();
            return patt3327$temp instanceof IJetpackItem && (jetpackItem = (IJetpackItem)patt3327$temp).canUseJetpack((ItemStack)stack);
        });
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(jetpack.getItem())) {
            return ItemStack.EMPTY;
        }
        return jetpack;
    }

    @NotNull
    public static ItemStack getPrimaryJetpack(LivingEntity entity) {
        return IJetpackItem.getJetpack(entity, stack -> stack.getItem() instanceof IJetpackItem);
    }

    private static ItemStack getJetpack(LivingEntity entity, Predicate<ItemStack> matcher) {
        ItemStack chest = entity.getItemBySlot(EquipmentSlot.CHEST);
        if (matcher.test(chest)) {
            return chest;
        }
        if (Mekanism.hooks.CuriosLoaded) {
            return CuriosIntegration.findFirstCurio(entity, matcher);
        }
        return ItemStack.EMPTY;
    }

    public static <PLAYER extends Player> boolean handleJetpackMotion(PLAYER player, JetpackMode mode, double thrust, Predicate<PLAYER> ascendingCheck) {
        Vec3 motion = player.getDeltaMovement();
        if (mode == JetpackMode.VECTOR && player.isShiftKeyDown()) {
            mode = JetpackMode.NORMAL;
        }
        if ((mode == JetpackMode.NORMAL || mode == JetpackMode.VECTOR) && player.isFallFlying()) {
            Vec3 forward = player.getLookAngle();
            Vec3 drag = forward.scale(1.5).subtract(motion).scale(0.5);
            Vec3 delta = forward.scale(thrust).add(drag);
            player.addDeltaMovement(delta);
            return false;
        }
        if (mode == JetpackMode.NORMAL) {
            Vec3 delta = new Vec3(0.08 * motion.x, thrust * IJetpackItem.getVerticalCoefficient(motion.y()), 0.08 * motion.z);
            player.addDeltaMovement(delta);
        } else if (mode == JetpackMode.VECTOR) {
            Vec3 thrustVec = player.getUpVector(1.0f).scale(thrust);
            Vec3 delta = new Vec3(thrustVec.x, thrustVec.y * IJetpackItem.getVerticalCoefficient(motion.y()), thrustVec.z);
            player.addDeltaMovement(delta);
        } else if (mode == JetpackMode.HOVER) {
            boolean descending;
            boolean ascending = ascendingCheck.test(player);
            if (ascending == (descending = player.isDescending())) {
                if (motion.y() > 0.0) {
                    player.setDeltaMovement(motion.x(), Math.max(motion.y() - thrust, 0.0), motion.z());
                } else if (motion.y() < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                    player.setDeltaMovement(motion.x(), Math.min(motion.y() + thrust, 0.0), motion.z());
                }
            } else if (ascending) {
                player.setDeltaMovement(motion.x(), Math.min(motion.y() + thrust, 2.0 * thrust), motion.z());
            } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                player.setDeltaMovement(motion.x(), Math.max(motion.y() - thrust, -2.0 * thrust), motion.z());
            }
        }
        return true;
    }

    private static double getVerticalCoefficient(double currentYVelocity) {
        return Math.min(1.0, Math.exp(-currentYVelocity));
    }

    public static <PLAYER extends Player> JetpackMode getPlayerJetpackMode(PLAYER player, JetpackMode mode, Predicate<PLAYER> ascendingCheck) {
        if (!player.isSpectator() && mode != JetpackMode.DISABLED) {
            boolean ascending = ascendingCheck.test(player);
            if (mode == JetpackMode.HOVER ? ascending && !player.isDescending() || !CommonPlayerTickHandler.isOnGroundOrSleeping(player) : ascending) {
                return mode;
            }
        }
        return JetpackMode.DISABLED;
    }

    @NothingNullByDefault
    public static enum JetpackMode implements IIncrementalEnum<JetpackMode>,
    IHasModeIcon
    {
        NORMAL(MekanismLang.JETPACK_NORMAL, EnumColor.DARK_GREEN, "jetpack_normal.png"),
        HOVER(MekanismLang.JETPACK_HOVER, EnumColor.DARK_AQUA, "jetpack_hover.png"),
        VECTOR(MekanismLang.JETPACK_VECTOR, EnumColor.ORANGE, "jetpack_vector.png"),
        DISABLED(MekanismLang.JETPACK_DISABLED, EnumColor.DARK_RED, "jetpack_off.png");

        private static final JetpackMode[] MODES;
        private final ILangEntry langEntry;
        private final EnumColor color;
        private final ResourceLocation hudIcon;
        private final ResourceLocation modeIcon;

        private JetpackMode(ILangEntry langEntry, EnumColor color, String icon) {
            this.langEntry = langEntry;
            this.color = color;
            this.hudIcon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, icon);
            this.modeIcon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_MODE, icon);
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translateColored(this.color);
        }

        @Override
        public JetpackMode byIndex(int index) {
            return JetpackMode.byIndexStatic(index);
        }

        public ResourceLocation getHUDIcon() {
            return this.hudIcon;
        }

        public static JetpackMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public ResourceLocation getModeIcon() {
            return this.modeIcon;
        }

        static {
            MODES = JetpackMode.values();
        }
    }
}

