/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.util.RegistryUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopyAttachmentsLootFunction
implements LootItemFunction {
    public static final Codec<CopyAttachmentsLootFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NeoForgeRegistries.ATTACHMENT_TYPES.byNameCodec().listOf().fieldOf("attachments").forGetter(function -> function.attachments)).apply((Applicative)instance, CopyAttachmentsLootFunction::new));
    private final List<AttachmentType<?>> attachments;

    private CopyAttachmentsLootFunction(List<AttachmentType<?>> attachments) {
        this.attachments = attachments;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_ATTACHMENTS.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity != null) {
            for (AttachmentType<?> attachment : this.attachments) {
                try {
                    this.copyAttachment((IAttachmentHolder)blockEntity, (IAttachmentHolder)stack, attachment);
                }
                catch (Exception e) {
                    Mekanism.logger.error("Could not copy attachment '{}' to item: {}", (Object)NeoForgeRegistries.ATTACHMENT_TYPES.getKey(attachment), (Object)RegistryUtils.getName(stack.getItem()));
                }
            }
        }
        return stack;
    }

    private <ATTACHMENT> void copyAttachment(IAttachmentHolder source, IAttachmentHolder target, AttachmentType<ATTACHMENT> attachmentType) {
        Optional existingData = source.getExistingData(attachmentType);
        if (existingData.isPresent()) {
            target.setData(attachmentType, existingData.get());
        }
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final List<AttachmentType<?>> attachmentTypes = new ArrayList();

        protected Builder() {
        }

        public Builder copy(Holder<AttachmentType<?>> attachment) {
            return this.copy((AttachmentType)attachment.value());
        }

        public Builder copy(AttachmentType<?> attachment) {
            this.attachmentTypes.add(attachment);
            return this;
        }

        public LootItemFunction build() {
            this.attachmentTypes.sort(Comparator.comparing(arg_0 -> ((Registry)NeoForgeRegistries.ATTACHMENT_TYPES).getKey(arg_0)));
            return new CopyAttachmentsLootFunction(this.attachmentTypes);
        }
    }
}

