/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopyContainersLootFunction
implements LootItemFunction {
    public static final Codec<CopyContainersLootFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NeoForgeExtraCodecs.withAlternative((MapCodec)ContainerType.CODEC.flatComapMap(List::of, list -> {
        if (list.size() == 1) {
            return DataResult.success((Object)((ContainerType)list.get(0)));
        }
        return DataResult.error(() -> "Must be a single container type to be represented as a direct reference");
    }).fieldOf("type"), (MapCodec)ContainerType.CODEC.listOf().fieldOf("types")).forGetter(function -> function.containerTypes)).apply((Applicative)instance, CopyContainersLootFunction::new));
    private final List<ContainerType<?, ?, ?>> containerTypes;

    private CopyContainersLootFunction(List<ContainerType<?, ?, ?>> containerTypes) {
        this.containerTypes = containerTypes;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_CONTAINERS.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TileEntityMekanism) {
            TileEntityMekanism tile = (TileEntityMekanism)blockEntity;
            for (ContainerType<?, ?, ?> containerType : this.containerTypes) {
                containerType.copyTo(tile, stack);
            }
            if (IRadiationManager.INSTANCE.isRadiationEnabled() && !tile.getGasTanks(null).isEmpty()) {
                TileEntityChemicalTank chemicalTank;
                if (tile instanceof TileEntityChemicalTank && (chemicalTank = (TileEntityChemicalTank)tile).getTier() == ChemicalTankTier.CREATIVE) {
                    return stack;
                }
                for (IGasTank tank : ContainerType.GAS.getAttachmentContainersIfPresent((IAttachmentHolder)stack)) {
                    if (tank.isEmpty() || !((GasStack)tank.getStack()).has(GasAttributes.Radiation.class)) continue;
                    tank.setEmpty();
                }
            }
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final List<ContainerType<?, ?, ?>> containerTypes = new ArrayList();

        protected Builder() {
        }

        public Builder copy(ContainerType<?, ?, ?> containerType) {
            this.containerTypes.add(containerType);
            return this;
        }

        public LootItemFunction build() {
            this.containerTypes.sort(Comparator.comparing(ContainerType::getAttachmentName));
            return new CopyContainersLootFunction(this.containerTypes);
        }
    }
}

