/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.attachments.component.AttachedFrequencyComponent;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.lib.frequency.IFrequencyHandler;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopyFrequencyLootFunction
implements LootItemFunction {
    public static final CopyFrequencyLootFunction INSTANCE = new CopyFrequencyLootFunction();

    private CopyFrequencyLootFunction() {
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_FREQUENCIES.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof IFrequencyHandler) {
            IFrequencyHandler frequencyHandler = (IFrequencyHandler)blockEntity;
            ((AttachedFrequencyComponent)stack.getData(MekanismAttachmentTypes.FREQUENCY_COMPONENT)).copyFrom(frequencyHandler.getFrequencyComponent());
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }
}

