/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.attachments.security.SecurityObject;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.lib.security.ISecurityTile;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.component.TileComponentSecurity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopySecurityLootFunction
implements LootItemFunction {
    public static final CopySecurityLootFunction INSTANCE = new CopySecurityLootFunction();

    private CopySecurityLootFunction() {
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_SECURITY.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ISecurityTile) {
            ISecurityTile tile = (ISecurityTile)blockEntity;
            TileComponentSecurity security = tile.getSecurity();
            SecurityObject securityObject = (SecurityObject)stack.getData(MekanismAttachmentTypes.SECURITY);
            securityObject.setSecurityMode(security.getMode());
            securityObject.setOwnerUUID(security.getOwnerUUID());
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }
}

