/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import java.util.Set;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.attachments.component.AttachedSideConfig;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopySideConfigLootFunction
implements LootItemFunction {
    public static final CopySideConfigLootFunction INSTANCE = new CopySideConfigLootFunction();

    private CopySideConfigLootFunction() {
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_SIDE_CONFIG.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ISideConfiguration) {
            ISideConfiguration tile = (ISideConfiguration)blockEntity;
            ((AttachedSideConfig)stack.getData(MekanismAttachmentTypes.SIDE_CONFIG)).copyFrom(tile.getConfig());
            ((AttachedEjector)stack.getData(MekanismAttachmentTypes.EJECTOR)).copyFrom(tile.getEjector());
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return MekanismLootFunctions.BLOCK_ENTITY_LOOT_CONTEXT;
    }

    public static LootItemFunction.Builder builder() {
        return () -> INSTANCE;
    }
}

