/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.loot;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mekanism.api.IDisableableEnum;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.OverflowAware;
import mekanism.common.item.loot.MekanismLootFunctions;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.TransporterUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public class CopyToAttachmentsLootFunction
implements LootItemFunction {
    public static final Codec<CopyToAttachmentsLootFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NbtProviders.CODEC.fieldOf("source").forGetter(function -> function.source), (App)CopyOperation.CODEC.listOf().fieldOf("ops").forGetter(function -> function.operations)).apply((Applicative)instance, CopyToAttachmentsLootFunction::new));
    private final NbtProvider source;
    private final List<CopyOperation<?>> operations;

    private CopyToAttachmentsLootFunction(NbtProvider source, List<CopyOperation<?>> operations) {
        this.source = source;
        this.operations = operations;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)MekanismLootFunctions.COPY_TO_ATTACHMENTS.get();
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        Tag tag = this.source.get(lootContext);
        if (tag != null) {
            for (CopyOperation<?> operation : this.operations) {
                operation.apply(stack, tag);
            }
        }
        return stack;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    public static Builder copyData(NbtProvider source) {
        return new Builder(source);
    }

    public static Builder copyData(LootContext.EntityTarget entityTarget) {
        return CopyToAttachmentsLootFunction.copyData(ContextNbtProvider.forContextEntity((LootContext.EntityTarget)entityTarget));
    }

    private record CopyOperation<ATTACHMENT>(CopyNbtFunction.Path sourcePath, AttachmentType<ATTACHMENT> target) {
        public static final Codec<CopyOperation<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CopyNbtFunction.Path.CODEC.fieldOf("source").forGetter(CopyOperation::sourcePath), (App)NeoForgeRegistries.ATTACHMENT_TYPES.byNameCodec().fieldOf("target").forGetter(CopyOperation::target)).apply((Applicative)instance, CopyOperation::new));

        public void apply(ItemStack targetStack, Tag sourceTag) {
            try {
                List list = this.sourcePath.path().get(sourceTag);
                if (!list.isEmpty()) {
                    Tag source = (Tag)Iterables.getLast((Iterable)list);
                    if (CopyOperation.handleSpecialCased(targetStack, this.target, source)) {
                        return;
                    }
                    Object data = targetStack.getData(this.target);
                    if (data instanceof Boolean) {
                        if (source == ByteTag.ONE) {
                            this.setBoolean(targetStack, true);
                        } else if (source == ByteTag.ZERO) {
                            this.setBoolean(targetStack, false);
                        }
                    } else if (data instanceof Integer) {
                        if (source instanceof IntTag) {
                            IntTag intTag = (IntTag)source;
                            this.setInteger(targetStack, intTag.getAsInt());
                        }
                    } else if (data instanceof Long) {
                        if (source instanceof LongTag) {
                            LongTag longTag = (LongTag)source;
                            this.setLong(targetStack, longTag.getAsLong());
                        }
                    } else if (data instanceof FloatingLong) {
                        if (source instanceof StringTag) {
                            StringTag stringTag = (StringTag)source;
                            this.setFloatingLong(targetStack, FloatingLong.parseFloatingLong(stringTag.getAsString()));
                        }
                    } else if (data instanceof boolean[]) {
                        if (source instanceof ByteArrayTag) {
                            ByteArrayTag byteArrayTag = (ByteArrayTag)source;
                            this.setBooleanArray(targetStack, byteArrayTag.getAsByteArray());
                        }
                    } else if (data instanceof Item) {
                        if (source instanceof StringTag) {
                            StringTag stringTag = (StringTag)source;
                            this.setItem(targetStack, ResourceLocation.tryParse((String)stringTag.getAsString()));
                        }
                    } else if (data instanceof ItemStack) {
                        if (source instanceof CompoundTag) {
                            CompoundTag compoundTag = (CompoundTag)source;
                            this.setItem(targetStack, ItemStack.of((CompoundTag)compoundTag));
                        }
                    } else if (data instanceof Optional) {
                        Object t;
                        Optional optional = (Optional)data;
                        if (optional.isPresent() && (t = optional.get()) instanceof Enum) {
                            Enum enumData = (Enum)t;
                            if (source instanceof IntTag) {
                                IntTag intTag = (IntTag)source;
                                this.setOptionalEnum(targetStack, (Enum[])enumData.getDeclaringClass().getEnumConstants(), intTag.getAsInt());
                            }
                        }
                    } else if (data instanceof Enum) {
                        Enum enumData = (Enum)data;
                        if (source instanceof IntTag) {
                            IntTag intTag = (IntTag)source;
                            this.setEnum(targetStack, (Enum[])enumData.getDeclaringClass().getEnumConstants(), intTag.getAsInt());
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static boolean handleSpecialCased(ItemStack targetStack, AttachmentType<?> target, Tag source) {
            if (target == MekanismAttachmentTypes.TRANSPORTER_COLOR.value()) {
                if (source instanceof IntTag) {
                    IntTag intTag = (IntTag)source;
                    targetStack.setData(MekanismAttachmentTypes.TRANSPORTER_COLOR, Optional.ofNullable(TransporterUtils.readColor(intTag.getAsInt())));
                }
            } else if (target == MekanismAttachmentTypes.OVERFLOW_AWARE.value()) {
                if (source instanceof ListTag) {
                    ListTag listTag = (ListTag)source;
                    ((OverflowAware)targetStack.getData(MekanismAttachmentTypes.OVERFLOW_AWARE)).deserializeNBT(listTag);
                }
            } else {
                return false;
            }
            return true;
        }

        private void setBoolean(ItemStack stack, boolean value) {
            stack.setData(this.target, (Object)value);
        }

        private void setInteger(ItemStack stack, int value) {
            stack.setData(this.target, (Object)value);
        }

        private void setLong(ItemStack stack, long value) {
            stack.setData(this.target, (Object)value);
        }

        private void setFloatingLong(ItemStack stack, FloatingLong value) {
            stack.setData(this.target, (Object)value);
        }

        private void setBooleanArray(ItemStack stack, byte[] value) {
            boolean[] booleans = new boolean[value.length];
            for (int i = 0; i < value.length; ++i) {
                booleans[i] = value[i] == 1;
            }
            stack.setData(this.target, (Object)booleans);
        }

        private void setItem(ItemStack stack, @Nullable ResourceLocation registryName) {
            if (registryName != null) {
                stack.setData(this.target, (Object)((Item)BuiltInRegistries.ITEM.get(registryName)));
            }
        }

        private void setItem(ItemStack stack, ItemStack item) {
            stack.setData(this.target, (Object)item);
        }

        private <ENUM> void setEnum(ItemStack stack, ENUM[] values, int index) {
            IDisableableEnum disableableEnum;
            ENUM value = MathUtils.getByIndexMod(values, index);
            if (value instanceof IDisableableEnum && !(disableableEnum = (IDisableableEnum)value).isEnabled()) {
                value = values[0];
            }
            stack.setData(this.target, value);
        }

        private <ENUM> void setOptionalEnum(ItemStack stack, ENUM[] values, int index) {
            Optional<Object> optionalValue = Optional.of(MathUtils.getByIndexMod(values, index)).filter(value -> {
                IDisableableEnum disableableEnum;
                return !(value instanceof IDisableableEnum) || (disableableEnum = (IDisableableEnum)value).isEnabled();
            });
            stack.setData(this.target, optionalValue);
        }
    }

    public static class Builder
    implements LootItemFunction.Builder {
        private final List<CopyOperation<?>> operations = new ArrayList();
        private final NbtProvider source;

        protected Builder(NbtProvider source) {
            this.source = source;
        }

        public Builder copy(String sourcePath, Holder<AttachmentType<?>> target) {
            return this.copy(sourcePath, (AttachmentType)target.value());
        }

        public Builder copy(String sourcePath, AttachmentType<?> target) {
            try {
                this.operations.add(new CopyOperation(CopyNbtFunction.Path.of((String)sourcePath), target));
                return this;
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public LootItemFunction build() {
            this.operations.sort(Comparator.comparing(operation -> operation.sourcePath().string()).thenComparing(operation -> NeoForgeRegistries.ATTACHMENT_TYPES.getKey(operation.target())));
            return new CopyToAttachmentsLootFunction(this.source, this.operations);
        }
    }
}

